/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.view;

import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFilesFolder;
import org.eclipse.vtp.desktop.projects.core.view.CopyAction;
import org.eclipse.vtp.desktop.projects.core.view.PasteAction;

public class EditActionGroup
extends ActionGroup {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private TextActionHandler textActionHandler;
    private Shell shell;

    public EditActionGroup(Shell aShell) {
        this.shell = aShell;
        this.makeActions();
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        LinkedList<IResource> deleteSelection = new LinkedList<IResource>();
        for (Object obj : selection.toList()) {
            IResource resource;
            if (obj instanceof IResource) {
                deleteSelection.add((IResource)obj);
                continue;
            }
            if (obj instanceof IMediaFilesFolder || !(obj instanceof IAdaptable) || (resource = (IResource)((IAdaptable)obj).getAdapter(IResource.class)) == null) continue;
            deleteSelection.add(resource);
        }
        boolean anyResourceSelected = !selection.isEmpty() && selection.size() == deleteSelection.size();
        this.copyAction.selectionChanged(selection);
        menu.appendToGroup("group.edit", (IAction)this.copyAction);
        this.pasteAction.selectionChanged(selection);
        menu.appendToGroup("group.edit", (IAction)this.pasteAction);
        if (anyResourceSelected) {
            this.deleteAction.selectionChanged(selection);
            menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.textActionHandler == null) {
            this.textActionHandler = new TextActionHandler(actionBars);
        }
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.updateActionBars();
        this.textActionHandler.updateActionBars();
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        this.clipboard = new Clipboard(this.shell.getDisplay());
        this.pasteAction = new PasteAction(this.shell, this.clipboard);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new CopyAction(this.shell, this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        IShellProvider sp = new IShellProvider(){

            public Shell getShell() {
                return EditActionGroup.this.shell;
            }
        };
        this.deleteAction = new DeleteResourceAction(sp);
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.copyAction.selectionChanged(selection);
        this.pasteAction.selectionChanged(selection);
        this.deleteAction.selectionChanged(selection);
    }
}

