/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.view;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFile;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObject;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaObjectContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaProject;
import org.eclipse.vtp.desktop.model.interactive.core.IPromptSet;
import org.eclipse.vtp.desktop.model.interactive.core.InteractiveWorkflowCore;

public class MediaProjectContentProvider
implements IPipelinedTreeContentProvider,
IDoubleClickListener {
    private Viewer viewer = null;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            IMediaProject workflowProject = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaProject((IProject)parentElement);
            return workflowProject.getChildren().toArray();
        }
        if (parentElement instanceof IMediaObjectContainer) {
            return ((IMediaObjectContainer)parentElement).getChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            return ((IProject)element).getWorkspace().getRoot();
        }
        if (element instanceof IMediaObject) {
            IMediaObjectContainer con = ((IMediaObject)element).getParent();
            if (con instanceof IMediaProject) {
                return con.getAdapter(IResource.class);
            }
            return con;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            return true;
        }
        return element instanceof IMediaObjectContainer;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)inputElement).getProjects();
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.viewer != null) {
            ((CommonViewer)this.viewer).removeDoubleClickListener((IDoubleClickListener)this);
        }
        this.viewer = viewer;
        if (viewer != null) {
            ((CommonViewer)this.viewer).addDoubleClickListener((IDoubleClickListener)this);
        }
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        LinkedList<IMediaObject> newChildren = new LinkedList<IMediaObject>();
        if (aParent instanceof IProject) {
            IProject project = (IProject)aParent;
            try {
                if (InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().isMediaProject(project)) {
                    IMediaProject workflowProject = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaProject(project);
                    List workflowResources = workflowProject.getChildren();
                    Iterator iterator = theCurrentChildren.iterator();
                    block2: while (iterator.hasNext()) {
                        Object child = iterator.next();
                        if (!(child instanceof IResource)) continue;
                        IResource resource = (IResource)child;
                        for (IMediaObject workflowResource : workflowResources) {
                            if (!workflowResource.getName().equals(resource.getName())) continue;
                            iterator.remove();
                            newChildren.add(workflowResource);
                            continue block2;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        theCurrentChildren.addAll(newChildren);
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
        this.getPipelinedChildren(anInput, theCurrentElements);
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        if (aSuggestedParent instanceof IResource) {
            IResource resource = (IResource)aSuggestedParent;
            IMediaObject workflowResource = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaObject(resource);
            if (workflowResource != null && !(workflowResource instanceof IMediaProject)) {
                return workflowResource;
            }
        }
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        Object parentObj = anAddModification.getParent();
        if (parentObj instanceof IResource) {
            IResource parent = (IResource)parentObj;
            IMediaObject workflowParent = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaObject(parent);
            if (workflowParent != null && !(workflowParent instanceof IMediaProject)) {
                anAddModification.setParent((Object)workflowParent);
            }
            Set children = anAddModification.getChildren();
            LinkedList<IMediaObject> newChildren = new LinkedList<IMediaObject>();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                Object childObj = iterator.next();
                if (!(childObj instanceof IResource)) continue;
                IResource childResource = (IResource)childObj;
                IMediaObject workflowChild = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaObject(childResource);
                if (workflowChild == null) continue;
                iterator.remove();
                newChildren.add(workflowChild);
            }
            children.addAll(newChildren);
        }
        return anAddModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        boolean changed = false;
        Set children = aRefreshSynchronization.getRefreshTargets();
        LinkedList<IMediaObject> newTargets = new LinkedList<IMediaObject>();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Object childObj = iterator.next();
            if (!(childObj instanceof IResource)) continue;
            IResource childResource = (IResource)childObj;
            IMediaObject workflowChild = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaObject(childResource);
            if (workflowChild == null) continue;
            iterator.remove();
            newTargets.add(workflowChild);
            changed = true;
        }
        children.addAll(newTargets);
        return changed;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        Set children = aRemoveModification.getChildren();
        final LinkedList<IMediaObject> parents = new LinkedList<IMediaObject>();
        for (Object childObj : children) {
            if (!(childObj instanceof IResource)) continue;
            IResource childResource = (IResource)childObj;
            IMediaObject workflowParent = InteractiveWorkflowCore.getDefault().getInteractiveWorkflowModel().convertToMediaObject((IResource)childResource.getParent());
            if (workflowParent == null) continue;
            parents.add(workflowParent);
        }
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (IMediaObject parent : parents) {
                    ((TreeViewer)MediaProjectContentProvider.this.viewer).refresh((Object)parent);
                }
            }
        });
        return aRemoveModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object sel = selection.getFirstElement();
        if (sel instanceof IMediaFile) {
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IMediaFile)sel).getUnderlyingFile());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        } else if (sel instanceof IPromptSet) {
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IPromptSet)sel).getUnderlyingFile());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }
}

