/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.view;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.vtp.desktop.model.core.IWorkflowResource;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.interactive.core.IInteractiveWorkflowProject;
import org.eclipse.vtp.desktop.projects.interactive.core.dialogs.ReplicateLanguageDialog;

public class ReplicateLanguageAction
extends SelectionListenerAction {
    public static final String ID = "OpenVXML.ReplicateLanguageAction";
    private Shell shell;

    public ReplicateLanguageAction(Shell shell) {
        super("Replication Language");
        Assert.isNotNull((Object)shell);
        this.shell = shell;
        this.setToolTipText("Replicate media configuration to another language");
        this.setId(ID);
    }

    public void run() {
        if (Workbench.getInstance().saveAllEditors(true)) {
            List selectedResources = this.getSelectedResources();
            IWorkflowResource wr = WorkflowCore.getDefault().getWorkflowModel().convertToWorkflowResource((IResource)selectedResources.get(0));
            if (wr != null && wr instanceof IInteractiveWorkflowProject) {
                IInteractiveWorkflowProject project = (IInteractiveWorkflowProject)wr;
                List languages = project.getSupportedLanguages("org.eclipse.vtp.framework.interactions.voice.interaction");
                ReplicateLanguageDialog rld = new ReplicateLanguageDialog(this.shell);
                rld.setLanguage(languages);
                rld.setProject(project);
                rld.open();
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        if (selectedResources.size() != 1) {
            return false;
        }
        return this.selectionIsOfType(4);
    }
}

