/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFile;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaResource;
import org.eclipse.vtp.desktop.model.interactive.core.internal.MediaFile;
import org.eclipse.vtp.desktop.projects.interactive.core.Activator;

public class CreateGrammarWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IMediaContainer mediaContainer = null;
    private GrammarWizardPage bwp = new GrammarWizardPage();
    private MediaFile createdGrammar = null;
    IConfigurationElement configElement = null;

    public CreateGrammarWizard() {
        this.addPage((IWizardPage)this.bwp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object sel = selection.getFirstElement();
        if (sel instanceof IMediaContainer) {
            this.mediaContainer = (IMediaContainer)sel;
        } else if (sel instanceof IMediaFile) {
            this.mediaContainer = ((IMediaFile)sel).getParentMediaContainer();
        }
    }

    public MediaFile getGrammar() {
        return this.createdGrammar;
    }

    public boolean performFinish() {
        try {
            MediaFile mediaFile = (MediaFile)this.mediaContainer.create(String.valueOf(this.bwp.grammarNameField.getText()) + (this.bwp.grammarNameField.getText().endsWith(".grxml") ? "" : ".grxml"));
            if (this.bwp.voiceGrammarButton.getSelection()) {
                mediaFile.getUnderlyingFile().setContents(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("voice_grammar_template.grxml"), true, false, null);
            } else if (this.bwp.dtmfTemplateButton.getSelection()) {
                InputStream tempin = Activator.class.getClassLoader().getResourceAsStream("dtmf_grammar_gen_template.grxml");
                StringBuffer text = new StringBuffer();
                byte[] buf = new byte[10240];
                int len = tempin.read(buf);
                while (len != -1) {
                    text.append(new String(buf, 0, len));
                    len = tempin.read(buf);
                }
                String contents = text.toString();
                contents = contents.replaceAll("\\[min\\]", this.bwp.minDigitsField.getText());
                contents = contents.replaceAll("\\[max\\]", this.bwp.maxDigitsField.getText());
                mediaFile.getUnderlyingFile().setContents((InputStream)new ByteArrayInputStream(contents.getBytes()), true, false, null);
            } else {
                mediaFile.getUnderlyingFile().setContents(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("dtmf_grammar_template.grxml"), true, false, null);
            }
            this.createdGrammar = mediaFile;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private class GrammarWizardPage
    extends WizardPage {
        Text grammarNameField;
        Button voiceGrammarButton;
        Button dtmfGrammarButton;
        Button dtmfTemplateButton;
        Text minDigitsField;
        Text maxDigitsField;

        public GrammarWizardPage() {
            super("GrammarPage", "Enter a name for the grammar file", null);
            this.grammarNameField = null;
            this.voiceGrammarButton = null;
            this.dtmfGrammarButton = null;
            this.dtmfTemplateButton = null;
            this.minDigitsField = null;
            this.maxDigitsField = null;
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new FormLayout());
            Label grammarNameLabel = new Label(comp, 0);
            grammarNameLabel.setText("Grammar File Name:");
            grammarNameLabel.setSize(grammarNameLabel.computeSize(-1, -1));
            FormData brandNameLabelData = new FormData();
            brandNameLabelData.left = new FormAttachment(0, 10);
            brandNameLabelData.top = new FormAttachment(0, 30);
            brandNameLabelData.right = new FormAttachment(0, 10 + grammarNameLabel.getSize().x);
            brandNameLabelData.bottom = new FormAttachment(0, 30 + grammarNameLabel.getSize().y);
            grammarNameLabel.setLayoutData((Object)brandNameLabelData);
            this.grammarNameField = new Text(comp, 2052);
            this.grammarNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String n = GrammarWizardPage.this.grammarNameField.getText();
                    try {
                        for (IMediaResource mr : CreateGrammarWizard.this.mediaContainer.listMediaResources()) {
                            if (!mr.getName().equals(n)) continue;
                            GrammarWizardPage.this.setErrorMessage("A grammar file already exists with that name.");
                            GrammarWizardPage.this.setPageComplete(false);
                            return;
                        }
                        GrammarWizardPage.this.setErrorMessage(null);
                        GrammarWizardPage.this.setPageComplete(true);
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            this.grammarNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String currentName = String.valueOf(GrammarWizardPage.this.grammarNameField.getText().substring(0, e.start)) + e.text + GrammarWizardPage.this.grammarNameField.getText(e.end, GrammarWizardPage.this.grammarNameField.getText().length() - 1);
                    if (currentName.length() > 255) {
                        e.doit = false;
                        return;
                    }
                }
            });
            FormData brandNameFieldData = new FormData();
            brandNameFieldData.left = new FormAttachment((Control)grammarNameLabel, 10);
            brandNameFieldData.top = new FormAttachment(0, 29);
            brandNameFieldData.right = new FormAttachment(100, -10);
            this.grammarNameField.setLayoutData((Object)brandNameFieldData);
            this.voiceGrammarButton = new Button(comp, 16);
            this.voiceGrammarButton.setText("Voice Grammar");
            this.voiceGrammarButton.setSelection(true);
            FormData voiceButtonData = new FormData();
            voiceButtonData.left = new FormAttachment(0, 10);
            voiceButtonData.top = new FormAttachment((Control)grammarNameLabel, 20);
            voiceButtonData.right = new FormAttachment(100, -10);
            this.voiceGrammarButton.setLayoutData((Object)voiceButtonData);
            this.dtmfGrammarButton = new Button(comp, 16);
            this.dtmfGrammarButton.setText("DTMF Grammar");
            FormData dtmfButtonData = new FormData();
            dtmfButtonData.left = new FormAttachment(0, 10);
            dtmfButtonData.top = new FormAttachment((Control)this.voiceGrammarButton, 20);
            dtmfButtonData.right = new FormAttachment(100, -10);
            this.dtmfGrammarButton.setLayoutData((Object)dtmfButtonData);
            this.dtmfTemplateButton = new Button(comp, 32);
            this.dtmfTemplateButton.setText("Use this template");
            FormData dtmfTemplateData = new FormData();
            dtmfTemplateData.left = new FormAttachment(0, 30);
            dtmfTemplateData.top = new FormAttachment((Control)this.dtmfGrammarButton, 15);
            dtmfTemplateData.right = new FormAttachment(100, -10);
            this.dtmfTemplateButton.setLayoutData((Object)dtmfTemplateData);
            Label minDigitsLabel = new Label(comp, 0);
            minDigitsLabel.setText("Minimum Digits");
            FormData minDigitsLabelData = new FormData();
            minDigitsLabelData.left = new FormAttachment(0, 50);
            minDigitsLabelData.top = new FormAttachment((Control)this.dtmfTemplateButton, 15);
            minDigitsLabel.setLayoutData((Object)minDigitsLabelData);
            this.minDigitsField = new Text(comp, 2048);
            FormData minDigitsFieldData = new FormData();
            minDigitsFieldData.left = new FormAttachment((Control)minDigitsLabel, 20);
            minDigitsFieldData.top = new FormAttachment((Control)this.dtmfTemplateButton, 15);
            minDigitsFieldData.right = new FormAttachment((Control)minDigitsLabel, 50, 131072);
            this.minDigitsField.setLayoutData((Object)minDigitsFieldData);
            this.minDigitsField.setEnabled(false);
            Label maxDigitsLabel = new Label(comp, 0);
            maxDigitsLabel.setText("Maximum Digits");
            FormData maxDigitsLabelData = new FormData();
            maxDigitsLabelData.left = new FormAttachment(0, 50);
            maxDigitsLabelData.top = new FormAttachment((Control)minDigitsLabel, 15);
            maxDigitsLabel.setLayoutData((Object)maxDigitsLabelData);
            this.maxDigitsField = new Text(comp, 2048);
            FormData maxDigitsFieldData = new FormData();
            maxDigitsFieldData.left = new FormAttachment((Control)maxDigitsLabel, 20);
            maxDigitsFieldData.top = new FormAttachment((Control)minDigitsLabel, 15);
            maxDigitsFieldData.right = new FormAttachment((Control)maxDigitsLabel, 50, 131072);
            this.maxDigitsField.setLayoutData((Object)maxDigitsFieldData);
            this.maxDigitsField.setEnabled(false);
            this.dtmfTemplateButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    GrammarWizardPage.this.minDigitsField.setEnabled(GrammarWizardPage.this.dtmfTemplateButton.getSelection());
                    GrammarWizardPage.this.maxDigitsField.setEnabled(GrammarWizardPage.this.dtmfTemplateButton.getSelection());
                }
            });
            this.setControl((Control)comp);
        }
    }
}

