/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.wizards;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.vtp.desktop.model.core.IWorkflowProject;
import org.eclipse.vtp.desktop.model.core.WorkflowCore;
import org.eclipse.vtp.desktop.model.core.branding.BrandManager;
import org.eclipse.vtp.desktop.model.core.branding.IBrand;
import org.eclipse.vtp.desktop.model.core.internal.branding.Brand;
import org.eclipse.vtp.desktop.model.core.internal.branding.DefaultBrandManager;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionType;
import org.eclipse.vtp.desktop.model.interactive.core.InteractionTypeManager;
import org.eclipse.vtp.desktop.model.interactive.core.internal.InteractionTypeSupport;
import org.eclipse.vtp.desktop.model.interactive.core.internal.InteractiveWorkflowProject;
import org.eclipse.vtp.desktop.projects.core.util.BrandConfigurationScreen;
import org.eclipse.vtp.desktop.projects.core.util.ConfigurationBrandManager;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionSupportManager;
import org.eclipse.vtp.desktop.projects.interactive.core.util.InteractionTypeConfigurationScreen;
import org.eclipse.vtp.desktop.projects.interactive.core.util.LanguageConfigurationScreen;
import org.eclipse.vtp.framework.util.Guid;

public class CreateInteractiveWorkflowProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    ApplicationPage applicationPage = null;
    BuildPathPage buildPathPage = null;
    InteractionTypePage interactionTypePage = null;
    LanguagePage languagePage = null;
    IConfigurationElement configElement = null;
    private ConfigurationBrandManager brandManager = null;
    private InteractionSupportManager supportManager = null;

    public CreateInteractiveWorkflowProjectWizard() {
        DefaultBrandManager defaultManager = new DefaultBrandManager();
        defaultManager.setDefaultBrand((IBrand)new Brand(Guid.createGUID(), "Default"));
        this.brandManager = new ConfigurationBrandManager((BrandManager)defaultManager);
        LinkedList<InteractionTypeSupport> supportList = new LinkedList<InteractionTypeSupport>();
        List installedTypes = InteractionTypeManager.getInstance().getInteractionTypes();
        for (InteractionType installedType : installedTypes) {
            InteractionTypeSupport typeSupport = new InteractionTypeSupport(installedType.getId(), installedType.getName());
            supportList.add(typeSupport);
            typeSupport.addLanguageSupport("English");
        }
        this.supportManager = new InteractionSupportManager();
        this.supportManager.init(supportList);
        this.applicationPage = new ApplicationPage();
        this.buildPathPage = new BuildPathPage();
        this.interactionTypePage = new InteractionTypePage();
        this.languagePage = new LanguagePage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.applicationPage);
        this.addPage((IWizardPage)this.buildPathPage);
        this.addPage((IWizardPage)this.interactionTypePage);
        this.addPage((IWizardPage)this.languagePage);
    }

    public boolean performFinish() {
        InteractiveWorkflowProject project = (InteractiveWorkflowProject)WorkflowCore.getDefault().getWorkflowModel().createWorkflowProject("org.eclipse.vtp.desktop.model.interactive.core.InteractiveWorkflowProjectNature", this.applicationPage.nameField.getText());
        this.buildPathPage.configureBuildPath((IWorkflowProject)project);
        project.setInteractionTypeSupport(this.supportManager.getSupport());
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return this.applicationPage.isPageComplete();
    }

    public class ApplicationPage
    extends WizardPage {
        Text nameField;

        public ApplicationPage() {
            super("CreateApplicationPage", "Create Application", null);
            this.nameField = null;
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setBackground(parent.getDisplay().getSystemColor(1));
            this.setControl((Control)comp);
            Label hostLabel = new Label(comp, 0);
            hostLabel.setBackground(comp.getBackground());
            hostLabel.setText("Application Name:");
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            this.nameField = new Text(comp, 2052);
            this.nameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String text = e.text;
                    char[] chars = text.toCharArray();
                    String currentName = String.valueOf(ApplicationPage.this.nameField.getText().substring(0, e.start)) + e.text + ApplicationPage.this.nameField.getText(e.end, ApplicationPage.this.nameField.getText().length() - 1);
                    if (currentName.length() > 255) {
                        e.doit = false;
                        return;
                    }
                    int i = 0;
                    while (i < chars.length) {
                        if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '$' && chars[i] != '_') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            this.nameField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (ApplicationPage.this.nameField.getText().length() == 0) {
                        ApplicationPage.this.setPageComplete(false);
                    } else {
                        IProject[] existingProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int i = 0;
                        while (i < existingProjects.length) {
                            if (ApplicationPage.this.nameField.getText().equalsIgnoreCase(existingProjects[i].getName())) {
                                ApplicationPage.this.setPageComplete(false);
                                ApplicationPage.this.setErrorMessage("Another project already exists with that name.");
                                return;
                            }
                            ++i;
                        }
                        ApplicationPage.this.setPageComplete(true);
                        ApplicationPage.this.setErrorMessage(null);
                    }
                    ApplicationPage.this.getWizard().getContainer().updateButtons();
                }
            });
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            comp.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 10);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 10 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            FormData hostFieldFormData = new FormData();
            hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
            hostFieldFormData.top = new FormAttachment(0, 10);
            hostFieldFormData.right = new FormAttachment(100, -10);
            this.nameField.setLayoutData((Object)hostFieldFormData);
        }

        public String getApplicationName() {
            return this.nameField.getText();
        }
    }

    public class BuildPathPage
    extends WizardPage {
        BrandConfigurationScreen screen;

        public BuildPathPage() {
            super("ConfigureBuildPathPage", "Branding", null);
            this.screen = new BrandConfigurationScreen();
            this.screen.init((BrandManager)CreateInteractiveWorkflowProjectWizard.this.brandManager);
            this.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new FillLayout());
            this.setControl((Control)comp);
            this.screen.createContents(comp);
        }

        void configureBuildPath(IWorkflowProject project) {
            CreateInteractiveWorkflowProjectWizard.this.brandManager.saveTo(project.getBrandManager(), true);
        }
    }

    public class InteractionTypePage
    extends WizardPage {
        InteractionTypeConfigurationScreen screen;

        public InteractionTypePage() {
            super("InteractionTypePage", "Interaction Type Support", null);
            this.screen = new InteractionTypeConfigurationScreen();
            this.screen.setSupport(CreateInteractiveWorkflowProjectWizard.this.supportManager);
            this.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new FillLayout());
            this.setControl((Control)comp);
            this.screen.createContents(comp);
        }

        void configureBuildPath(InteractiveWorkflowProject project) {
        }
    }

    public class LanguagePage
    extends WizardPage {
        LanguageConfigurationScreen screen;

        public LanguagePage() {
            super("LanguagePage", "Languge Support", null);
            this.screen = new LanguageConfigurationScreen();
            this.screen.init((BrandManager)CreateInteractiveWorkflowProjectWizard.this.brandManager, CreateInteractiveWorkflowProjectWizard.this.supportManager);
            this.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new FillLayout());
            this.setControl((Control)comp);
            this.screen.createContents(comp);
        }

        void configureBuildPath(InteractiveWorkflowProject project) {
        }
    }
}

