/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.interactive.core.wizards;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaContainer;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFile;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaFolder;
import org.eclipse.vtp.desktop.model.interactive.core.IMediaResource;

public class CreateMediaFolderWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IMediaContainer container = null;
    private MediaFolderWizardPage mfwp = new MediaFolderWizardPage();
    IConfigurationElement configElement = null;

    public CreateMediaFolderWizard() {
        this.addPage((IWizardPage)this.mfwp);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object sel = selection.getFirstElement();
        if (sel instanceof IMediaContainer) {
            this.container = (IMediaContainer)sel;
        } else if (sel instanceof IMediaFile) {
            this.container = ((IMediaFile)sel).getParentMediaContainer();
        }
    }

    public boolean performFinish() {
        try {
            this.container.makeDirectory(this.mfwp.mediaFolderNameField.getText());
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private class MediaFolderWizardPage
    extends WizardPage {
        Text mediaFolderNameField;

        public MediaFolderWizardPage() {
            super("MediaFolderPage", "Enter a name for the folder", null);
            this.mediaFolderNameField = null;
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            Label folderNameLabel = new Label(comp, 0);
            folderNameLabel.setText("Folder Name:");
            folderNameLabel.setSize(folderNameLabel.computeSize(-1, -1));
            this.mediaFolderNameField = new Text(comp, 2052);
            this.mediaFolderNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String n = MediaFolderWizardPage.this.mediaFolderNameField.getText();
                    List resources = null;
                    try {
                        resources = CreateMediaFolderWizard.this.container.listMediaResources();
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                        MediaFolderWizardPage.this.setPageComplete(false);
                        MediaFolderWizardPage.this.setErrorMessage("Could not enumerate existing resources.");
                        MediaFolderWizardPage.this.mediaFolderNameField.setEnabled(false);
                    }
                    for (IMediaResource resource : resources) {
                        if (!(resource instanceof IMediaFolder) || !resource.getName().equals(n)) continue;
                        MediaFolderWizardPage.this.setErrorMessage("A folder already exists with that name.");
                        MediaFolderWizardPage.this.setPageComplete(false);
                        return;
                    }
                    MediaFolderWizardPage.this.setErrorMessage(null);
                    MediaFolderWizardPage.this.setPageComplete(true);
                }
            });
            this.mediaFolderNameField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String currentName = String.valueOf(MediaFolderWizardPage.this.mediaFolderNameField.getText().substring(0, e.start)) + e.text + MediaFolderWizardPage.this.mediaFolderNameField.getText(e.end, MediaFolderWizardPage.this.mediaFolderNameField.getText().length() - 1);
                    if (currentName.length() > 255) {
                        e.doit = false;
                        return;
                    }
                }
            });
            comp.setLayout((Layout)new FormLayout());
            FormData folderNameLabelData = new FormData();
            folderNameLabelData.left = new FormAttachment(0, 10);
            folderNameLabelData.top = new FormAttachment(0, 30);
            folderNameLabelData.right = new FormAttachment(0, 10 + folderNameLabel.getSize().x);
            folderNameLabelData.bottom = new FormAttachment(0, 30 + folderNameLabel.getSize().y);
            folderNameLabel.setLayoutData((Object)folderNameLabelData);
            FormData folderNameFieldData = new FormData();
            folderNameFieldData.left = new FormAttachment((Control)folderNameLabel, 10);
            folderNameFieldData.top = new FormAttachment(0, 29);
            folderNameFieldData.right = new FormAttachment(100, -10);
            this.mediaFolderNameField.setLayoutData((Object)folderNameFieldData);
            this.setControl((Control)comp);
        }
    }
}

