/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views.extended.pallet;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.pshelf.AbstractRenderer;
import org.eclipse.nebula.widgets.pshelf.PShelf;
import org.eclipse.nebula.widgets.pshelf.PShelfItem;
import org.eclipse.nebula.widgets.pshelf.RedmondShelfRenderer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.views.pallet.PallateProviderManager;
import org.eclipse.vtp.desktop.views.pallet.Pallet;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.eclipse.vtp.desktop.views.pallet.PalletItemTransfer;

public class ShelfPallet
implements Pallet {
    private IDesign container = null;
    private Map<PalletItemProvider, ProviderSection> sectionsByProvider = Collections.emptyMap();
    private Composite mainComp = null;
    private PShelf expandBar = null;
    private static final Comparator<PalletItemProvider> PALLATE_ITEM_PROVIDER_SORT = new Comparator<PalletItemProvider>(){

        @Override
        public int compare(PalletItemProvider left, PalletItemProvider right) {
            PalletItemProvider leftProvider = left;
            PalletItemProvider rightProvider = right;
            int diff = leftProvider.getRanking() - rightProvider.getRanking();
            if (diff == 0) {
                diff = leftProvider.getName().compareTo(rightProvider.getName());
            }
            return diff;
        }
    };
    private static final ViewerSorter PALLATE_ITEM_SORT = new ViewerSorter(){

        public int compare(Viewer viewer, Object left, Object right) {
            PalletItem leftItem = (PalletItem)left;
            PalletItem rightItem = (PalletItem)right;
            return leftItem.getName().compareTo(rightItem.getName());
        }
    };

    public void setContainer(IDesign container) {
        this.container = container;
    }

    public void createControl(Composite parent) {
        TreeMap<PalletItemProvider, ProviderSection> sectionsByProvider = new TreeMap<PalletItemProvider, ProviderSection>(PALLATE_ITEM_PROVIDER_SORT);
        for (PalletItemProvider provider : PallateProviderManager.getPallateProviders()) {
            int numItems = 0;
            List items = provider.getPalletItems();
            for (PalletItem item : items) {
                if (!item.canBeContainedBy(this.container)) continue;
                ++numItems;
            }
            if (numItems <= 0) continue;
            sectionsByProvider.put(provider, new ProviderSection(provider));
        }
        this.sectionsByProvider = Collections.unmodifiableMap(sectionsByProvider);
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setLayout((Layout)new FillLayout());
        this.expandBar = new PShelf(this.mainComp, 512);
        this.expandBar.setRenderer((AbstractRenderer)new RedmondShelfRenderer());
        for (ProviderSection ps : this.sectionsByProvider.values()) {
            ps.initialize();
        }
    }

    public Control getControl() {
        return this.mainComp;
    }

    public void destroy() {
        for (ProviderSection ps : this.sectionsByProvider.values()) {
            ps.destroy();
        }
        this.mainComp.dispose();
        this.mainComp = null;
        this.sectionsByProvider = Collections.emptyMap();
    }

    private final class ProviderSection
    extends LabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider,
    IMenuListener,
    DragSourceListener,
    PalletItemObserver {
        final PalletItemProvider provider;
        PShelfItem section = null;
        TableViewer viewer = null;

        ProviderSection(PalletItemProvider provider) {
            this.provider = provider;
        }

        void initialize() {
            this.section = new PShelfItem(ShelfPallet.this.expandBar, 0);
            this.section.setText(this.provider.getName());
            Composite body = this.section.getBody();
            body.setLayout((Layout)new FillLayout());
            this.viewer = new TableViewer(body, 512);
            this.viewer.setContentProvider((IContentProvider)this);
            this.viewer.setLabelProvider((IBaseLabelProvider)this);
            this.viewer.setSorter(PALLATE_ITEM_SORT);
            this.viewer.setInput((Object)this.provider);
            this.viewer.addDragSupport(3, new Transfer[]{PalletItemTransfer.getInstance()}, (DragSourceListener)this);
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener((IMenuListener)this);
            this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
            this.provider.addPalletItemObserver((PalletItemObserver)this);
        }

        void destroy() {
            this.provider.removePalletItemObserver((PalletItemObserver)this);
            this.section = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            LinkedList<PalletItem> palletItems = new LinkedList<PalletItem>();
            PalletItemProvider provider = (PalletItemProvider)inputElement;
            List items = provider.getPalletItems();
            for (PalletItem item : items) {
                if (!item.canBeContainedBy(ShelfPallet.this.container)) continue;
                palletItems.add(item);
            }
            return palletItems.toArray();
        }

        public void dispose() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((PalletItem)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image icon = ((PalletItem)element).getIcon();
            if (icon != null) {
                return icon;
            }
            return Activator.getDefault().getImageRegistry().get("ICON_MODULE");
        }

        public void menuAboutToShow(IMenuManager manager) {
            this.provider.createMenu(null, manager, ((IStructuredSelection)this.viewer.getSelection()).toList().toArray(new PalletItem[0]));
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = true;
            PalletItemTransfer.getInstance().setPalletItem((PalletItem)((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
        }

        public void dragSetData(DragSourceEvent event) {
            if (PalletItemTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = PalletItemTransfer.getInstance().getPalletItem();
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void palletItemsChanged() {
            try {
                System.err.println("Viewer null? " + Boolean.toString(this.viewer == null));
                if (this.viewer != null) {
                    this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProviderSection.this.viewer.refresh();
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

