/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views.pallet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.osgi.framework.Bundle;

public class PallateProviderManager {
    public static String PALLET_PROVIDER_EXTENSION_ID = "org.eclipse.vtp.desktop.views.palletProvider";

    public static List<PalletItemProvider> getPallateProviders() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(PALLET_PROVIDER_EXTENSION_ID);
        ArrayList<PalletItemProvider> providers = new ArrayList<PalletItemProvider>(primitiveExtensions.length);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String className = primitiveExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            try {
                Class providerClass = contributor.loadClass(className);
                if (!PalletItemProvider.class.isAssignableFrom(providerClass)) {
                    throw new IllegalArgumentException("The provided class is not a PalletItemProvider: " + providerClass);
                }
                PalletItemProvider providerObject = (PalletItemProvider)providerClass.newInstance();
                providers.add(providerObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return providers;
    }
}

