/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views.pallet;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPage;
import org.eclipse.vtp.desktop.model.core.design.IDesign;
import org.eclipse.vtp.desktop.views.Activator;
import org.eclipse.vtp.desktop.views.pallet.Pallet;
import org.eclipse.vtp.desktop.views.pallet.PalletFocusListener;
import org.eclipse.vtp.desktop.views.pallet.PalletFocusProvider;
import org.eclipse.vtp.desktop.views.pallet.PalletManager;

public class PalletPage
implements IPage,
IPropertyChangeListener,
PalletFocusListener {
    private Composite comp;
    private Pallet pallet;
    private IAdaptable container;

    public PalletPage() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.pallet = PalletManager.getDefault().createCurrentPallet();
    }

    public void setContainer(IAdaptable container) {
        PalletFocusProvider focusProvider;
        if (this.container != null && (focusProvider = (PalletFocusProvider)container.getAdapter(PalletFocusProvider.class)) != null) {
            focusProvider.removeFocusListener(this);
        }
        this.container = container;
        this.pallet.setContainer((IDesign)container.getAdapter(IDesign.class));
        focusProvider = (PalletFocusProvider)container.getAdapter(PalletFocusProvider.class);
        if (focusProvider != null) {
            focusProvider.addFocusListener(this);
        }
    }

    public void createControl(Composite parent) {
        try {
            this.comp = new Composite(parent, 0);
            this.comp.setLayout((Layout)new FillLayout());
            this.pallet.createControl(this.comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.pallet.destroy();
        this.comp.dispose();
    }

    public Control getControl() {
        return this.comp;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.comp.setFocus();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("CurrentPallet")) {
            this.pallet.destroy();
            this.pallet = PalletManager.getDefault().createCurrentPallet();
            this.pallet.setContainer((IDesign)this.container.getAdapter(IDesign.class));
            this.pallet.createControl(this.comp);
            this.comp.layout(true, true);
        }
    }

    @Override
    public void focusChanged(IDesign design) {
        this.pallet.destroy();
        this.pallet = PalletManager.getDefault().createCurrentPallet();
        this.pallet.setContainer(design);
        this.pallet.createControl(this.comp);
        this.comp.layout(true, true);
    }
}

