/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views.preferences;

import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.vtp.desktop.views.Activator;
import org.eclipse.vtp.desktop.views.pallet.PalletManager;

public class PalletPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List<PalletManager.PalletRecord> pallets = PalletManager.getDefault().getInstalledPallets();
    Combo palletCombo = null;

    public PalletPreferencePage() {
    }

    public PalletPreferencePage(String title) {
        super(title);
    }

    public PalletPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label themeLabel = new Label(comp, 0);
        themeLabel.setText("Editor Theme:");
        themeLabel.setLayoutData((Object)new GridData());
        this.palletCombo = new Combo(comp, 12);
        int selected = -1;
        int defaultSelected = -1;
        int i = 0;
        while (i < this.pallets.size()) {
            PalletManager.PalletRecord pallet = this.pallets.get(i);
            this.palletCombo.add(pallet.getName());
            if (pallet.getId().equals(PalletManager.defaultPalletId)) {
                defaultSelected = i;
            }
            if (pallet.getId().equals(PalletManager.getDefault().getCurrentPallet())) {
                selected = i;
            }
            ++i;
        }
        if (selected != -1) {
            this.palletCombo.select(selected);
        } else if (defaultSelected != -1) {
            this.palletCombo.select(defaultSelected);
        }
        this.palletCombo.setLayoutData((Object)new GridData(768));
        return comp;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("CurrentPallet", this.pallets.get(this.palletCombo.getSelectionIndex()).getId());
        return super.performOk();
    }
}

