/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.actions;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;

public class AssignmentAction
implements IAction {
    protected final IActionContext context;
    protected final IVariableRegistry variableRegistry;
    protected final AssignmentConfiguration[] configurations;

    public AssignmentAction(IActionContext context, IVariableRegistry variableRegistry, AssignmentConfiguration[] configurations) {
        this.context = context;
        this.variableRegistry = variableRegistry;
        this.configurations = configurations;
    }

    public IActionResult execute() {
        return this.execute(Collections.<String, String>emptyMap(), true);
    }

    protected IActionResult execute(Map<String, String> values, boolean overwrite) {
        try {
            if (this.context.isInfoEnabled()) {
                this.context.info("Performing variable assignments");
            }
            int i = 0;
            while (i < this.configurations.length) {
                IDataObject object;
                if (this.context.isInfoEnabled()) {
                    this.context.info("Assigning variable \"" + this.configurations[i].getName() + "\"");
                }
                if ((object = this.variableRegistry.getVariable(this.configurations[i].getName())) == null || object != null && overwrite) {
                    object = this.variableRegistry.createVariable(this.configurations[i].getType(), this.configurations[i].isSecured());
                    String value = this.configurations[i].getValue();
                    if (values.containsKey(this.configurations[i].getName())) {
                        value = values.get(this.configurations[i].getName());
                    }
                    if (value != null) {
                        IDataObject toSet = object;
                        String primaryField = object.getType().getPrimaryFieldName();
                        if (primaryField != null) {
                            toSet = object.getField(primaryField);
                        }
                        if (toSet instanceof IBooleanObject) {
                            ((IBooleanObject)toSet).setValue(value);
                        } else if (toSet instanceof IDateObject) {
                            ((IDateObject)toSet).setValue(value);
                        } else if (toSet instanceof IDecimalObject) {
                            ((IDecimalObject)toSet).setValue(value);
                        } else if (toSet instanceof INumberObject) {
                            ((INumberObject)toSet).setValue(value);
                        } else if (toSet instanceof IStringObject) {
                            ((IStringObject)toSet).setValue(value);
                        }
                    }
                    this.variableRegistry.setVariable(this.configurations[i].getName(), object);
                    if (this.context.isReportingEnabled()) {
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        ((Dictionary)props).put("event", "assignment");
                        ((Dictionary)props).put("event.key", this.configurations[i].getName());
                        ((Dictionary)props).put("event.value", this.configurations[i].isSecured() ? "**Secured**" : String.valueOf(object));
                        this.context.report(3, "Assigned variable \"" + this.configurations[i].getName() + "\" to \"" + (this.configurations[i].isSecured() ? "**Secured**" : String.valueOf(object)) + "\"", props);
                    }
                }
                ++i;
            }
            if (this.context.isInfoEnabled()) {
                this.context.info("Variable assignments complete");
            }
            return this.context.createResult("default");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.assign", (Throwable)e);
        }
    }
}

