/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.actions;

import java.math.BigDecimal;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.ILastResult;
import org.eclipse.vtp.framework.common.ILastResultData;
import org.eclipse.vtp.framework.common.IScriptingEngine;
import org.eclipse.vtp.framework.common.IScriptingService;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.configurations.BranchConfiguration;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;

public class BranchAction
implements IAction {
    private static final String[] COMPARISONS = new String[]{"=", "<", "<=", ">", ">=", "!="};
    private final IActionContext context;
    private final IVariableRegistry variableRegistry;
    private final IScriptingService scriptingService;
    private final BranchConfiguration[] configurations;
    private final ILastResult lastResult;

    public BranchAction(IActionContext context, IVariableRegistry variableRegistry, IScriptingService scriptingService, BranchConfiguration[] configurations, ILastResult lastResult) {
        this.context = context;
        this.variableRegistry = variableRegistry;
        this.scriptingService = scriptingService;
        this.configurations = configurations;
        this.lastResult = lastResult;
    }

    public IActionResult execute() {
        try {
            if (this.context.isInfoEnabled()) {
                this.context.info("Performing comparison(s)");
            }
            int i = 0;
            while (i < this.configurations.length) {
                Object left = this.evaluate(this.configurations[i].getLeftType(), this.configurations[i].getLeftValue(), this.configurations[i].getLeftScriptingLanguage());
                Object right = this.evaluate(this.configurations[i].getRightType(), this.configurations[i].getRightValue(), this.configurations[i].getRightScriptingLanguage());
                boolean result = this.compare(left, right, this.configurations[i]);
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "branch");
                    ((Dictionary)props).put("branch.left", this.isSecured(left, this.configurations[i].isLeftSecured()) ? "**Secured**" : String.valueOf(left));
                    ((Dictionary)props).put("branch.operator", COMPARISONS[this.configurations[i].getType()]);
                    ((Dictionary)props).put("branch.right", this.isSecured(right, this.configurations[i].isRightSecured()) ? "**Secured**" : String.valueOf(right));
                    ((Dictionary)props).put("branch.result", String.valueOf(result));
                    this.context.report(3, "Comparison \"" + this.configurations[i].getLeftValue() + "\" " + COMPARISONS[this.configurations[i].getType()] + " \"" + this.configurations[i].getRightValue() + "\" evaluated to " + result, props);
                }
                if (result) {
                    return this.context.createResult(this.configurations[i].getPath());
                }
                ++i;
            }
            return this.context.createResult("default");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.branch", (Throwable)e);
        }
    }

    private Object evaluate(int operandType, String operandValue, String scriptingLanguage) {
        if (operandType == 0) {
            if (operandValue.startsWith("LastResult")) {
                List<ILastResultData> results = this.lastResult.getResults();
                if (results.size() < 1) {
                    return null;
                }
                ILastResultData data = results.get(0);
                String varName = operandValue.substring(11);
                if ("confidence".equals(varName)) {
                    return new Integer(data.getConfidence());
                }
                if ("utterance".equals(varName)) {
                    return data.getUtterence();
                }
                if ("inputmode".equals(varName)) {
                    return data.getInputMode();
                }
                if ("interpretation".equals(varName)) {
                    return data.getInterpretation();
                }
                return null;
            }
            return this.variableRegistry.getVariable(operandValue);
        }
        IScriptingEngine engine = this.scriptingService.createScriptingEngine(scriptingLanguage);
        if (engine == null) {
            return null;
        }
        return engine.execute(operandValue);
    }

    private boolean compare(Object left, Object right, BranchConfiguration configuration) {
        int comparison = configuration.getType();
        if (this.context.isInfoEnabled()) {
            this.context.info("Left object: " + (left == null ? "null" : left.getClass().getName()) + " (" + (this.isSecured(left, configuration.isLeftSecured()) ? "**Secured**" : String.valueOf(left)) + ") Right object: " + (right == null ? "null" : right.getClass().getName()) + " (" + (this.isSecured(right, configuration.isRightSecured()) ? "**Secured**" : String.valueOf(right)) + ")");
        }
        if (left instanceof IDataObject) {
            IDataObject data = (IDataObject)left;
            switch (comparison) {
                case 0: {
                    return data.isEqualTo(right);
                }
                case 1: {
                    return data.isLessThan(right);
                }
                case 2: {
                    return data.isLessThanOrEqualTo(right);
                }
                case 3: {
                    return data.isGreaterThan(right);
                }
                case 4: {
                    return data.isGreaterThanOrEqualTo(right);
                }
                case 5: {
                    return !data.isEqualTo(right);
                }
            }
            return false;
        }
        if (right instanceof IDataObject) {
            IDataObject data = (IDataObject)right;
            switch (comparison) {
                case 0: {
                    return data.isEqualTo(left);
                }
                case 3: {
                    return data.isLessThan(left);
                }
                case 4: {
                    return data.isLessThanOrEqualTo(left);
                }
                case 1: {
                    return data.isGreaterThan(left);
                }
                case 2: {
                    return data.isGreaterThanOrEqualTo(left);
                }
                case 5: {
                    return !data.isEqualTo(left);
                }
            }
            return false;
        }
        if (left == right) {
            return comparison == 0 || comparison == 2 || comparison == 4;
        }
        if (left == null || right == null) {
            return comparison == 5;
        }
        if (!(left instanceof String) && left instanceof Comparable && left.getClass().equals(right.getClass())) {
            return this.performCastComparison(left, right, comparison);
        }
        String leftString = left.toString();
        String rightString = right.toString();
        try {
            BigDecimal leftBD = new BigDecimal(leftString);
            BigDecimal rightBD = new BigDecimal(rightString);
            return this.performComparison(leftBD, rightBD, comparison);
        }
        catch (Exception exception) {
            return this.performComparison((Comparable)((Object)leftString), (Object)rightString, comparison);
        }
    }

    private boolean performCastComparison(Object left, Object right, int comparison) {
        return this.performComparison((Comparable)left, right, comparison);
    }

    private <T> boolean performComparison(Comparable<? super T> left, T right, int comparison) {
        switch (comparison) {
            case 0: {
                return left.compareTo(right) == 0;
            }
            case 1: {
                return left.compareTo(right) < 0;
            }
            case 2: {
                return left.compareTo(right) <= 0;
            }
            case 3: {
                return left.compareTo(right) > 0;
            }
            case 4: {
                return left.compareTo(right) >= 0;
            }
            case 5: {
                return left.compareTo(right) != 0;
            }
        }
        return false;
    }

    private boolean isSecured(Object value, boolean override) {
        if (override) {
            return true;
        }
        if (value instanceof IDataObject) {
            return ((IDataObject)value).isSecured();
        }
        return false;
    }
}

