/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.configurations;

import org.eclipse.vtp.framework.common.configurations.CommonConstants;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BranchConfiguration
implements IConfiguration,
CommonConstants {
    public static final int COMPARISON_TYPE_EQUAL = 0;
    public static final int COMPARISON_TYPE_LESS_THAN = 1;
    public static final int COMPARISON_TYPE_LESS_THAN_OR_EQUAL = 2;
    public static final int COMPARISON_TYPE_GREATER_THAN = 3;
    public static final int COMPARISON_TYPE_GREATER_THAN_OR_EQUAL = 4;
    public static final int COMPARISON_TYPE_NOT_EQUAL = 5;
    public static final int OPERAND_TYPE_VARIABLE = 0;
    public static final int OPERAND_TYPE_EXPRESSION = 1;
    private int type = 0;
    private String path = "";
    private int leftType = 0;
    private String leftValue = "";
    private boolean leftSecured = false;
    private String leftScriptingLanguage = null;
    private int rightType = 0;
    private String rightValue = "";
    private boolean rightSecured = false;
    private String rightScriptingLanguage = null;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path == null ? "" : path;
    }

    public int getLeftType() {
        return this.leftType;
    }

    public String getLeftValue() {
        return this.leftValue;
    }

    public boolean isLeftSecured() {
        return this.leftSecured;
    }

    public String getLeftScriptingLanguage() {
        return this.leftScriptingLanguage;
    }

    public void setLeftVariableValue(String leftValue) {
        this.leftType = 0;
        this.leftValue = leftValue == null ? "" : leftValue;
        this.leftScriptingLanguage = null;
    }

    public void setLeftExpressionValue(String leftValue, String leftScriptingLanguage) {
        this.leftType = 1;
        this.leftValue = leftValue == null ? "" : leftValue;
        this.leftScriptingLanguage = leftScriptingLanguage;
    }

    public void setLeftSecured(boolean leftSecured) {
        this.leftSecured = leftSecured;
    }

    public int getRightType() {
        return this.rightType;
    }

    public String getRightValue() {
        return this.rightValue;
    }

    public boolean isRightSecured() {
        return this.rightSecured;
    }

    public String getRightScriptingLanguage() {
        return this.rightScriptingLanguage;
    }

    public void setRightVariableValue(String rightValue) {
        this.rightType = 0;
        this.rightValue = rightValue == null ? "" : rightValue;
        this.rightScriptingLanguage = null;
    }

    public void setRightExpressionValue(String rightValue, String rightScriptingLanguage) {
        this.rightType = 1;
        this.rightValue = rightValue == null ? "" : rightValue;
        this.rightScriptingLanguage = rightScriptingLanguage;
    }

    public void setRightSecured(boolean rightSecured) {
        this.rightSecured = rightSecured;
    }

    public void load(Element configurationElement) {
        this.type = 0;
        String typeStr = configurationElement.getAttribute("type");
        if ("equal".equals(typeStr)) {
            this.type = 0;
        } else if ("less-than".equals(typeStr)) {
            this.type = 1;
        } else if ("less-than-or-equal".equals(typeStr)) {
            this.type = 2;
        } else if ("greater-than".equals(typeStr)) {
            this.type = 3;
        } else if ("greater-than-or-equal".equals(typeStr)) {
            this.type = 4;
        } else if ("not-equal".equals(typeStr)) {
            this.type = 5;
        }
        this.path = configurationElement.getAttribute("path");
        this.leftType = 0;
        this.leftValue = "";
        this.leftScriptingLanguage = null;
        NodeList leftList = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/common/configurations", "left-operand");
        if (leftList.getLength() > 0) {
            Element left = (Element)leftList.item(0);
            this.leftType = "expression".equalsIgnoreCase(left.getAttribute("type")) ? 1 : 0;
            this.leftValue = left.getAttribute("value");
            this.leftSecured = Boolean.parseBoolean(left.getAttribute("secured"));
            if (left.hasAttribute("scripting-language")) {
                this.leftScriptingLanguage = left.getAttribute("scripting-language");
            }
        }
        this.rightType = 0;
        this.rightValue = "";
        this.rightScriptingLanguage = null;
        NodeList rightList = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/common/configurations", "right-operand");
        if (rightList.getLength() > 0) {
            Element right = (Element)rightList.item(0);
            this.rightType = "expression".equalsIgnoreCase(right.getAttribute("type")) ? 1 : 0;
            this.rightValue = right.getAttribute("value");
            this.rightSecured = Boolean.parseBoolean(right.getAttribute("secured"));
            if (right.hasAttribute("scripting-language")) {
                this.rightScriptingLanguage = right.getAttribute("scripting-language");
            }
        }
    }

    public void save(Element configurationElement) {
        String typeStr = null;
        switch (this.type) {
            case 0: {
                typeStr = "equal";
                break;
            }
            case 1: {
                typeStr = "less-than";
                break;
            }
            case 2: {
                typeStr = "less-than-or-equal";
                break;
            }
            case 3: {
                typeStr = "greater-than";
                break;
            }
            case 4: {
                typeStr = "greater-than-or-equal";
                break;
            }
            case 5: {
                typeStr = "not-equal";
            }
        }
        configurationElement.setAttribute("type", typeStr);
        String leftName = "left-operand";
        String rightName = "right-operand";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            leftName = String.valueOf(prefix) + ":" + leftName;
            rightName = String.valueOf(prefix) + ":" + rightName;
        }
        configurationElement.setAttribute("path", this.path);
        Element left = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", leftName);
        left.setAttribute("type", this.leftType == 0 ? "variable" : "expression");
        left.setAttribute("value", this.leftValue);
        left.setAttribute("secured", Boolean.toString(this.leftSecured));
        if (this.leftScriptingLanguage != null) {
            left.setAttribute("scripting-language", this.leftScriptingLanguage);
        }
        configurationElement.appendChild(left);
        Element right = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", rightName);
        right.setAttribute("type", this.rightType == 0 ? "variable" : "expression");
        right.setAttribute("value", this.rightValue);
        right.setAttribute("secured", Boolean.toString(this.rightSecured));
        if (this.rightScriptingLanguage != null) {
            right.setAttribute("scripting-language", this.rightScriptingLanguage);
        }
        configurationElement.appendChild(right);
    }
}

