/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.configurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.common.configurations.CommonConstants;
import org.eclipse.vtp.framework.common.configurations.VariableMappingConfiguration;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DispatchConfiguration
implements IConfiguration,
CommonConstants {
    private String targetProcessURI = "";
    private final Map<String, VariableMappingConfiguration> variableMappings = new HashMap<String, VariableMappingConfiguration>();
    private final Map<String, Map<String, String>> outgoingData = new HashMap<String, Map<String, String>>();

    public String getTargetProcessURI() {
        return this.targetProcessURI;
    }

    public void setTargetProcessURI(String destinationURI) {
        this.targetProcessURI = destinationURI == null ? "" : destinationURI;
    }

    public String[] getVariableNames() {
        return this.variableMappings.keySet().toArray(new String[this.variableMappings.size()]);
    }

    public VariableMappingConfiguration getVariableMapping(String variableName) {
        if (variableName == null) {
            return null;
        }
        return this.variableMappings.get(variableName);
    }

    public void setVariableMapping(String variableName, VariableMappingConfiguration variableMapping) {
        if (variableName == null) {
            return;
        }
        if (variableMapping == null) {
            this.variableMappings.remove(variableName);
        } else {
            this.variableMappings.put(variableName, variableMapping);
        }
    }

    public String[] getOutgoingPaths() {
        return this.outgoingData.keySet().toArray(new String[this.outgoingData.size()]);
    }

    public String[] getOutgoingDataNames(String path) {
        Map<String, String> map = this.outgoingData.get(path);
        if (map == null) {
            return new String[0];
        }
        return map.keySet().toArray(new String[map.size()]);
    }

    public String getOutgoingDataValue(String path, String name) {
        Map<String, String> map = this.outgoingData.get(path);
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    public void setOutgoingDataValue(String path, String name, String value) {
        if (path == null || name == null) {
            return;
        }
        Map<String, String> map = this.outgoingData.get(path);
        if (map == null) {
            if (value == null) {
                return;
            }
            map = new HashMap<String, String>();
            this.outgoingData.put(path, map);
        }
        if (value == null) {
            map.remove(name);
            if (map.isEmpty()) {
                this.outgoingData.remove(path);
            }
        } else {
            map.put(name, value);
        }
    }

    public void clear() {
        this.targetProcessURI = "";
        this.variableMappings.clear();
    }

    public void load(Element configurationElement) {
        this.targetProcessURI = configurationElement.getAttribute("uri");
        this.variableMappings.clear();
        this.outgoingData.clear();
        NodeList nodes = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/common/configurations", "variable-mapping");
        int i = 0;
        while (i < nodes.getLength()) {
            Element mappingElement = (Element)nodes.item(i);
            String name = mappingElement.getAttribute("name");
            VariableMappingConfiguration mapping = new VariableMappingConfiguration();
            mapping.load(mappingElement);
            this.variableMappings.put(name, mapping);
            ++i;
        }
        nodes = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/common/configurations", "outgoing");
        i = 0;
        while (i < nodes.getLength()) {
            Element outgoingElement = (Element)nodes.item(i);
            String path = outgoingElement.getAttribute("path");
            NodeList nodes2 = outgoingElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/common/configurations", "entry");
            int j = 0;
            while (j < nodes2.getLength()) {
                Element entryElement = (Element)nodes2.item(j);
                String name = entryElement.getAttribute("key");
                this.setOutgoingDataValue(path, name, entryElement.getAttribute("value"));
                ++j;
            }
            ++i;
        }
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("uri", this.targetProcessURI);
        String variableMappingName = "variable-mapping";
        String outgoingName = "outgoing";
        String entryName = "entry";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            variableMappingName = String.valueOf(prefix) + ":" + variableMappingName;
            outgoingName = String.valueOf(prefix) + ":" + outgoingName;
            entryName = String.valueOf(prefix) + ":" + entryName;
        }
        for (Map.Entry<String, VariableMappingConfiguration> entry : this.variableMappings.entrySet()) {
            Element mappingElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", variableMappingName);
            entry.getValue().save(mappingElement);
            mappingElement.setAttribute("name", entry.getKey());
            configurationElement.appendChild(mappingElement);
        }
        for (String path : this.outgoingData.keySet()) {
            Element outgoingElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", outgoingName);
            outgoingElement.setAttribute("path", path);
            Map<String, String> map = this.outgoingData.get(path);
            for (String name : map.keySet()) {
                Element entryElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/common/configurations", entryName);
                entryElement.setAttribute("key", name);
                entryElement.setAttribute("value", map.get(name));
                outgoingElement.appendChild(entryElement);
            }
            configurationElement.appendChild(outgoingElement);
        }
    }
}

