/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.framework.common.ILastResult;
import org.eclipse.vtp.framework.common.ILastResultData;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.core.ISessionContext;

public class LastResult
implements ILastResult,
IScriptable {
    private final ISessionContext context;

    public LastResult(ISessionContext context) {
        this.context = context;
    }

    @Override
    public ILastResultData addResult(int confidence, String utterance, String inputMode, String interpretation) {
        String lengthString = (String)this.context.getAttribute("lastresult.length");
        if (lengthString == null || "".equals(lengthString)) {
            lengthString = "0";
        }
        int length = Integer.parseInt(lengthString);
        this.context.setAttribute("lastresult." + length + ".confidence", (Object)Integer.toString(confidence));
        this.context.setAttribute("lastresult." + length + ".utterance", (Object)utterance);
        this.context.setAttribute("lastresult." + length + ".inputmode", (Object)inputMode);
        this.context.setAttribute("lastresult." + length + ".interpretation", (Object)interpretation);
        this.context.setAttribute("lastresult.length", (Object)Integer.toString(length + 1));
        return new LastResultData(confidence, utterance, inputMode, interpretation);
    }

    @Override
    public void clear() {
        String lengthString = (String)this.context.getAttribute("lastresult.length");
        if (lengthString == null || "".equals(lengthString)) {
            return;
        }
        int length = Integer.parseInt(lengthString);
        int i = 0;
        while (i < length) {
            this.context.clearAttribute("lastresult." + i + ".confidence");
            this.context.clearAttribute("lastresult." + i + ".utterance");
            this.context.clearAttribute("lastresult." + i + ".inputmode");
            this.context.clearAttribute("lastresult." + i + ".interpretation");
            ++i;
        }
        this.context.clearAttribute("lastresult.length");
        this.context.clearAttribute("lastresult.markname");
        this.context.clearAttribute("lastresult.marktime");
    }

    @Override
    public List<ILastResultData> getResults() {
        String lengthString = (String)this.context.getAttribute("lastresult.length");
        if (lengthString == null || "".equals(lengthString)) {
            return Collections.emptyList();
        }
        int length = Integer.parseInt(lengthString);
        ArrayList<ILastResultData> ret = new ArrayList<ILastResultData>(length);
        int i = 0;
        while (i < length) {
            String confidenceString = (String)this.context.getAttribute("lastresult." + i + ".confidence");
            int confidence = Integer.parseInt(confidenceString);
            String utterance = (String)this.context.getAttribute("lastresult." + i + ".utterance");
            String inputMode = (String)this.context.getAttribute("lastresult." + i + ".inputmode");
            String interpretation = (String)this.context.getAttribute("lastresult." + i + ".interpretation");
            ret.add(new LastResultData(confidence, utterance, inputMode, interpretation));
            ++i;
        }
        return ret;
    }

    @Override
    public final String getName() {
        return "LastResult";
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public Object toValue() {
        return null;
    }

    @Override
    public final String[] getFunctionNames() {
        return new String[0];
    }

    @Override
    public final Object invokeFunction(String name, Object[] arguments) {
        return null;
    }

    @Override
    public final boolean hasItem(int index) {
        String lengthString = (String)this.context.getAttribute("lastresult.length");
        if (lengthString == null || "".equals(lengthString)) {
            lengthString = "0";
        }
        int length = Integer.parseInt(lengthString);
        return index >= 0 && index < length;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"length", "confidence", "utterance", "inputmode", "interpretation", "markname", "marktime"};
    }

    @Override
    public final boolean hasEntry(String name) {
        return "length".equals(name) || "confidence".equals(name) || "utterance".equals(name) || "inputmode".equals(name) || "interpretation".equals(name) || "markname".equals(name) || "marktime".equals(name);
    }

    @Override
    public final Object getItem(int index) {
        String lengthString = (String)this.context.getAttribute("lastresult.length");
        if (lengthString == null || "".equals(lengthString)) {
            return null;
        }
        String confidenceString = (String)this.context.getAttribute("lastresult." + index + ".confidence");
        int confidence = Integer.parseInt(confidenceString);
        String utterance = (String)this.context.getAttribute("lastresult." + index + ".utterance");
        String inputMode = (String)this.context.getAttribute("lastresult." + index + ".inputmode");
        String interpretation = (String)this.context.getAttribute("lastresult." + index + ".interpretation");
        return new LastResultData(confidence, utterance, inputMode, interpretation);
    }

    @Override
    public final Object getEntry(String name) {
        if ("length".equals(name)) {
            String lengthString = (String)this.context.getAttribute("lastresult.length");
            if (lengthString == null || "".equals(lengthString)) {
                lengthString = "0";
            }
            int length = Integer.parseInt(lengthString);
            return new Integer(length);
        }
        ILastResultData lrd = null;
        List<ILastResultData> results = this.getResults();
        if (results.size() > 0) {
            lrd = results.get(0);
        }
        if ("confidence".equals(name)) {
            return lrd == null ? null : new Integer(lrd.getConfidence());
        }
        if ("utterance".equals(name)) {
            return lrd == null ? null : lrd.getUtterence();
        }
        if ("inputmode".equals(name)) {
            return lrd == null ? null : lrd.getInputMode();
        }
        if ("interpretation".equals(name)) {
            return lrd == null ? null : lrd.getInterpretation();
        }
        if ("markname".equals(name)) {
            String markName = (String)this.context.getAttribute("lastresult.markname");
            if (markName == null) {
                markName = "";
            }
            return markName;
        }
        if ("marktime".equals(name)) {
            String markTime = (String)this.context.getAttribute("lastresult.marktime");
            if (markTime == null) {
                markTime = "0";
            }
            return markTime;
        }
        return null;
    }

    @Override
    public final boolean setItem(int index, Object value) {
        return false;
    }

    @Override
    public final boolean setEntry(String name, Object value) {
        return false;
    }

    @Override
    public final boolean clearItem(int index) {
        return false;
    }

    @Override
    public final boolean clearEntry(String name) {
        return false;
    }

    @Override
    public String getMarkName() {
        String markName = (String)this.context.getAttribute("lastresult.markname");
        if (markName == null) {
            markName = "";
        }
        return markName;
    }

    @Override
    public String getMarkTime() {
        String markTime = (String)this.context.getAttribute("lastresult.marktime");
        if (markTime == null) {
            markTime = "0";
        }
        return markTime;
    }

    @Override
    public void setMarkName(String name) {
        this.context.setAttribute("lastresult.markname", (Object)name);
    }

    @Override
    public void setMarkTime(String time) {
        this.context.setAttribute("lastresult.marktime", (Object)time);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    private class LastResultData
    implements ILastResultData,
    IScriptable {
        private int confidence = 0;
        private String utterance = null;
        private String inputMode = null;
        private String interpretation = null;

        public LastResultData(int confidence, String utterance, String inputMode, String interpretation) {
            this.confidence = confidence;
            this.utterance = utterance;
            this.inputMode = inputMode;
            this.interpretation = interpretation;
        }

        @Override
        public int getConfidence() {
            return this.confidence;
        }

        @Override
        public String getInputMode() {
            return this.inputMode;
        }

        @Override
        public String getInterpretation() {
            return this.interpretation;
        }

        @Override
        public String getUtterence() {
            return this.utterance;
        }

        @Override
        public boolean clearEntry(String name) {
            return false;
        }

        @Override
        public boolean clearItem(int index) {
            return false;
        }

        @Override
        public Object getEntry(String name) {
            if ("confidence".equals(name)) {
                return new Integer(this.confidence);
            }
            if ("utterance".equals(name)) {
                return this.utterance;
            }
            if ("inputmode".equals(name)) {
                return this.inputMode;
            }
            if ("interpretation".equals(name)) {
                return this.interpretation;
            }
            return null;
        }

        @Override
        public String[] getFunctionNames() {
            return new String[0];
        }

        @Override
        public Object getItem(int index) {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String[] getPropertyNames() {
            return new String[]{"confidence", "utterance", "inputmode", "interpretation"};
        }

        @Override
        public boolean hasEntry(String name) {
            return "confidence".equals(name) || "utterance".equals(name) || "inputmode".equals(name) || "interpretation".equals(name);
        }

        @Override
        public boolean hasItem(int index) {
            return false;
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        @Override
        public Object invokeFunction(String name, Object[] arguments) {
            return null;
        }

        @Override
        public boolean setEntry(String name, Object value) {
            return false;
        }

        @Override
        public boolean setItem(int index, Object value) {
            return false;
        }

        @Override
        public Object toValue() {
            return null;
        }

        @Override
        public boolean isMutable() {
            return false;
        }
    }
}

