/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.core.ILogger;

public class ScriptableLogger
implements IScriptable {
    private final ILogger logger;

    public ScriptableLogger(ILogger logger) {
        this.logger = logger;
    }

    private int toSeverityLevel(Object value) {
        String string = String.valueOf(value);
        if ("error".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("warn".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("info".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("debug".equalsIgnoreCase(string)) {
            return 4;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return 4;
        }
    }

    @Override
    public final String getName() {
        return "Log";
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public Object toValue() {
        return null;
    }

    @Override
    public final String[] getFunctionNames() {
        return new String[]{"isEnabled", "report", "log", "error", "warn", "info", "debug"};
    }

    @Override
    public final Object invokeFunction(String name, Object[] arguments) {
        if ("isEnabled".equals(name)) {
            if (arguments.length == 0) {
                return null;
            }
            return this.logger.isSeverityEnabled(this.toSeverityLevel(arguments[0])) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("report".equals(name)) {
            if (arguments.length < 2) {
                return null;
            }
            int severity = this.toSeverityLevel(arguments[0]);
            if (!this.logger.isSeverityEnabled(severity)) {
                return null;
            }
            String[] categories = null;
            if (arguments.length > 2) {
                categories = new String[arguments.length - 2];
                int i = 0;
                while (i < categories.length) {
                    categories[i] = String.valueOf(arguments[i + 1]);
                    ++i;
                }
            }
            this.logger.report(severity, categories, String.valueOf(arguments[arguments.length - 1]));
        } else {
            int severity = 4;
            String[] categories = null;
            if ("log".equals(name)) {
                if (arguments.length < 2) {
                    return null;
                }
                severity = this.toSeverityLevel(arguments[0]);
                if (!this.logger.isSeverityEnabled(severity)) {
                    return null;
                }
                if (arguments.length > 2) {
                    categories = new String[arguments.length - 2];
                    int i = 0;
                    while (i < categories.length) {
                        categories[i] = String.valueOf(arguments[i + 1]);
                        ++i;
                    }
                }
            } else {
                if (arguments.length < 1) {
                    return null;
                }
                severity = this.toSeverityLevel(name);
                if (!this.logger.isSeverityEnabled(severity)) {
                    return null;
                }
                if (arguments.length > 1) {
                    categories = new String[arguments.length - 1];
                    int i = 0;
                    while (i < categories.length) {
                        categories[i] = String.valueOf(arguments[i]);
                        ++i;
                    }
                }
            }
            this.logger.log(severity, categories, String.valueOf(arguments[arguments.length - 1]));
        }
        return null;
    }

    @Override
    public final boolean hasItem(int index) {
        return false;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[0];
    }

    @Override
    public final boolean hasEntry(String name) {
        return false;
    }

    @Override
    public final Object getItem(int index) {
        return null;
    }

    @Override
    public final Object getEntry(String name) {
        return null;
    }

    @Override
    public final boolean setItem(int index, Object value) {
        return false;
    }

    @Override
    public final boolean setEntry(String name, Object value) {
        return false;
    }

    @Override
    public final boolean clearItem(int index) {
        return false;
    }

    @Override
    public final boolean clearEntry(String name) {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

