/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.common.services;

import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.core.IProcessContext;

public class ScriptableProcessContext
implements IScriptable {
    private final IProcessContext context;
    private final ScriptableProperties properties = new ScriptableProperties();

    public ScriptableProcessContext(IProcessContext context) {
        this.context = context;
    }

    @Override
    public final String getName() {
        return "Process";
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public Object toValue() {
        return this.getEntry("id");
    }

    @Override
    public final String[] getFunctionNames() {
        return new String[]{"loadClass"};
    }

    @Override
    public final Object invokeFunction(String name, Object[] arguments) {
        if ("loadClass".equals(name)) {
            if (arguments.length != 1) {
                return null;
            }
            try {
                return this.context.loadClass(arguments[0].toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    @Override
    public final boolean hasItem(int index) {
        return false;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"id"};
    }

    @Override
    public final boolean hasEntry(String name) {
        return "id".equals(name) || this.properties.getName().equals(name);
    }

    @Override
    public final Object getItem(int index) {
        return null;
    }

    @Override
    public final Object getEntry(String name) {
        if ("id".equals(name)) {
            return this.context.getProcessID();
        }
        if (this.properties.getName().equals(name)) {
            return this.properties;
        }
        return null;
    }

    @Override
    public final boolean setItem(int index, Object value) {
        return false;
    }

    @Override
    public final boolean setEntry(String name, Object value) {
        return false;
    }

    @Override
    public final boolean clearItem(int index) {
        return false;
    }

    @Override
    public final boolean clearEntry(String name) {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    private final class ScriptableProperties
    implements IScriptable {
        private ScriptableProperties() {
        }

        @Override
        public String getName() {
            return "properties";
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        @Override
        public Object toValue() {
            return null;
        }

        @Override
        public String[] getFunctionNames() {
            return new String[0];
        }

        @Override
        public Object invokeFunction(String name, Object[] arguments) {
            return null;
        }

        @Override
        public boolean hasItem(int index) {
            return false;
        }

        @Override
        public String[] getPropertyNames() {
            return new String[0];
        }

        @Override
        public boolean hasEntry(String name) {
            return ScriptableProcessContext.this.context.getProperty(name) != null;
        }

        @Override
        public Object getItem(int index) {
            return null;
        }

        @Override
        public Object getEntry(String name) {
            return ScriptableProcessContext.this.context.getProperty(name);
        }

        @Override
        public boolean setItem(int index, Object value) {
            return false;
        }

        @Override
        public boolean setEntry(String name, Object value) {
            return false;
        }

        @Override
        public boolean clearItem(int index) {
            return false;
        }

        @Override
        public boolean clearEntry(String name) {
            return false;
        }

        @Override
        public boolean isMutable() {
            return false;
        }
    }
}

