/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.databases.actions;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.databases.IDatabase;
import org.eclipse.vtp.framework.databases.IDatabaseRegistry;
import org.eclipse.vtp.framework.databases.configurations.DatabaseCriteriaConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseMappingConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseQueryConfiguration;

public class DatabaseQueryAction
implements IAction {
    private final IActionContext context;
    private final IVariableRegistry variables;
    private final IDatabase database;
    private final String table;
    private final String resultName;
    private final IDataType arrayType;
    private final IDataType resultType;
    private final int resultLength;
    private final Map<String, IDataType> columns;
    private final Set<Criteria> criteria;
    private final Set<Mapping> mappings;
    private final int queryTimeout;

    public DatabaseQueryAction(IActionContext context, IDataTypeRegistry types, IVariableRegistry variables, IDatabaseRegistry databases, DatabaseQueryConfiguration configuration) {
        this.context = context;
        this.variables = variables;
        this.database = databases.getDatabase(configuration.getDatabase());
        this.table = configuration.getTable();
        this.resultName = configuration.getResultName();
        this.arrayType = types.getDataType("Array");
        this.resultType = types.getDataType(configuration.getResultType());
        this.resultLength = configuration.isResultArray() ? (configuration.getResultLimit() <= 0 ? Integer.MAX_VALUE : configuration.getResultLimit()) : 0;
        String[] columnNames = this.database.getColumnNames(this.table);
        LinkedHashMap<String, IDataType> columns = new LinkedHashMap<String, IDataType>(columnNames.length);
        int i = 0;
        while (i < columnNames.length) {
            columns.put(columnNames[i], this.database.getColumnType(this.table, columnNames[i]));
            ++i;
        }
        this.columns = Collections.unmodifiableMap(columns);
        DatabaseCriteriaConfiguration[] criteriaConfigurations = configuration.getCriteria();
        LinkedHashSet<Criteria> criteria = new LinkedHashSet<Criteria>(criteriaConfigurations.length);
        int i2 = 0;
        while (i2 < criteriaConfigurations.length) {
            criteria.add(new Criteria(criteriaConfigurations[i2]));
            ++i2;
        }
        this.criteria = Collections.unmodifiableSet(criteria);
        DatabaseMappingConfiguration[] mappingConfigurations = configuration.getMappings();
        LinkedHashSet<Mapping> mappings = new LinkedHashSet<Mapping>(mappingConfigurations.length);
        int i3 = 0;
        while (i3 < mappingConfigurations.length) {
            mappings.add(new Mapping(mappingConfigurations[i3]));
            ++i3;
        }
        this.mappings = Collections.unmodifiableSet(mappings);
        this.queryTimeout = 0;
    }

    public IActionResult execute() {
        IActionResult result;
        block14: {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("event", "dbquery.prepare");
            ((Dictionary)props).put("dbquery.databse", this.database);
            ((Dictionary)props).put("dbquery.table", this.table);
            ((Dictionary)props).put("dbquery.target", this.resultName);
            this.context.report(3, "Preparing SQL statement.", props);
            result = null;
            try {
                block13: {
                    Connection connection = this.database.getConnection();
                    if (connection != null) {
                        try {
                            PreparedStatement statement = this.buildStatement(connection);
                            if (statement == null) break block13;
                            try {
                                ResultSet resultSet = statement.executeQuery();
                                if (resultSet == null) break block13;
                                try {
                                    result = this.processResults(resultSet);
                                }
                                finally {
                                    resultSet.close();
                                }
                            }
                            finally {
                                statement.close();
                            }
                        }
                        finally {
                            connection.close();
                        }
                    }
                }
                props = new Hashtable(props);
                ((Dictionary)props).put("event", "dbquery.complete");
                this.context.report(3, "SQL query complete.", props);
            }
            catch (SQLException e) {
                if (result != null) break block14;
                result = this.context.createResult("error.database.connection", (Throwable)e);
            }
        }
        if (result == null) {
            this.context.createResult("error.database.connection");
        }
        return result;
    }

    private PreparedStatement buildStatement(Connection connection) throws SQLException {
        StringBuffer buffer = new StringBuffer("select");
        int length = buffer.length();
        for (Mapping mapping : this.mappings) {
            if (buffer.length() > length) {
                buffer.append(',');
            }
            mapping.appendSql(buffer);
        }
        if (buffer.length() == length) {
            buffer.append(' ').append('*');
        }
        buffer.append(" from ").append(this.table);
        boolean criteriaIsSecured = false;
        if (!this.criteria.isEmpty()) {
            buffer.append(" where ");
            length = buffer.length();
            for (Criteria criteriaElement : this.criteria) {
                criteriaElement.appendSql(buffer, buffer.length() > length);
                criteriaIsSecured |= criteriaElement.secured;
            }
            if (buffer.length() == length) {
                buffer.setLength(length - 7);
            }
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("event", "dbquery.execute");
        ((Dictionary)props).put("dbquery.databse", this.database);
        ((Dictionary)props).put("dbquery.table", this.table);
        ((Dictionary)props).put("dbquery.target", this.resultName);
        ((Dictionary)props).put("dbquery.sql", criteriaIsSecured ? "**Secured**" : buffer.toString());
        this.context.report(3, "Executing SQL statement: " + (criteriaIsSecured ? "**Secured**" : buffer.toString()), props);
        PreparedStatement statement = connection.prepareStatement(buffer.toString());
        int index = 1;
        for (Criteria criteriaElement : this.criteria) {
            index = criteriaElement.setValue(statement, index);
        }
        statement.setQueryTimeout(this.queryTimeout);
        return statement;
    }

    private IActionResult processResults(ResultSet resultSet) throws SQLException {
        IArrayObject array = null;
        IDataObject variable = this.variables.getVariable(this.resultName);
        if (this.resultLength == 0) {
            if (variable == null || !this.resultType.equals(variable.getType())) {
                variable = this.variables.createVariable(this.resultType);
                this.variables.setVariable(this.resultName, variable);
            }
        } else {
            if (variable == null || !this.arrayType.equals(variable.getType())) {
                array = (IArrayObject)this.variables.createVariable(this.arrayType);
                this.variables.setVariable(this.resultName, (IDataObject)array);
            } else {
                array = (IArrayObject)variable;
            }
            variable = null;
        }
        int resultCount = 0;
        int i = 0;
        while ((this.resultLength == 0 || i < this.resultLength) && resultSet.next()) {
            ++resultCount;
            if (variable == null) {
                variable = this.variables.createVariable(this.resultType);
            }
            for (Mapping mapping : this.mappings) {
                mapping.setValue(variable, resultSet);
            }
            if (array == null) break;
            array.addElement(variable);
            variable = null;
            ++i;
        }
        if (resultCount == 0 && array == null) {
            this.variables.clearVariable(this.resultName);
        }
        return this.context.createResult("default");
    }

    private final class Criteria {
        final String name;
        final String comparison;
        final IDataType type;
        final IDataObject value;
        boolean secured = false;

        Criteria(DatabaseCriteriaConfiguration configuration) {
            this.name = configuration.getName();
            switch (configuration.getComparison()) {
                case 1: {
                    this.comparison = " != ";
                    break;
                }
                case 2: {
                    this.comparison = " < ";
                    break;
                }
                case 3: {
                    this.comparison = " <= ";
                    break;
                }
                case 4: {
                    this.comparison = " > ";
                    break;
                }
                case 5: {
                    this.comparison = " >= ";
                    break;
                }
                case 0: {
                    this.comparison = " = ";
                    break;
                }
                default: {
                    this.comparison = null;
                }
            }
            this.type = (IDataType)DatabaseQueryAction.this.columns.get(this.name);
            String configuredValue = configuration.getValue();
            IDataObject value = null;
            switch (configuration.getType()) {
                case 1: {
                    value = DatabaseQueryAction.this.variables.getVariable(configuredValue);
                    if (value != null) {
                        if (value.getType().equals(this.type)) break;
                        configuredValue = value.toString();
                    }
                }
                case 2: {
                    value = DatabaseQueryAction.this.variables.createVariable(this.type);
                    if (value instanceof IBooleanObject) {
                        ((IBooleanObject)value).setValue((Object)configuredValue);
                        break;
                    }
                    if (value instanceof IDateObject) {
                        ((IDateObject)value).setValue((Object)configuredValue);
                        break;
                    }
                    if (value instanceof IDecimalObject) {
                        ((IDecimalObject)value).setValue((Object)configuredValue);
                        break;
                    }
                    if (value instanceof INumberObject) {
                        ((INumberObject)value).setValue((Object)configuredValue);
                        break;
                    }
                    if (value instanceof IStringObject) {
                        ((IStringObject)value).setValue((Object)configuredValue);
                        break;
                    }
                    value = null;
                }
            }
            this.value = value;
        }

        void appendSql(StringBuffer sql, boolean and) {
            if (this.comparison == null || this.value == null) {
                return;
            }
            if (and) {
                sql.append(" and ");
            }
            sql.append(this.name).append(this.comparison).append('?');
        }

        int setValue(PreparedStatement statement, int index) throws SQLException {
            if (this.comparison == null || this.value == null) {
                return index;
            }
            if (this.value instanceof IBooleanObject) {
                statement.setBoolean(index, ((IBooleanObject)this.value).getValue());
            } else if (this.value instanceof IDateObject) {
                statement.setTimestamp(index, new Timestamp(((IDateObject)this.value).getValue().getTime().getTime()));
            } else if (this.value instanceof IDecimalObject) {
                statement.setBigDecimal(index, ((IDecimalObject)this.value).getValue());
            } else if (this.value instanceof INumberObject) {
                statement.setInt(index, ((INumberObject)this.value).getValue());
            } else if (this.value instanceof IStringObject) {
                statement.setString(index, ((IStringObject)this.value).getValue());
            } else {
                return index;
            }
            DatabaseQueryAction.this.context.info("Using parameter: " + (this.value.isSecured() ? "**Secured**" : this.value.toString()));
            this.secured = this.value.isSecured();
            return index + 1;
        }
    }

    private final class Mapping {
        final String name;
        final IDataType type;
        final String value;

        Mapping(DatabaseMappingConfiguration configuration) {
            this.name = configuration.getName();
            this.type = configuration.getType() == 1 ? (IDataType)DatabaseQueryAction.this.columns.get(configuration.getValue()) : null;
            this.value = configuration.getValue();
        }

        void appendSql(StringBuffer sql) {
            if (this.type == null) {
                return;
            }
            sql.append(' ').append(this.value);
        }

        void setValue(IDataObject object, ResultSet resultSet) throws SQLException {
            IDataObject target = object;
            if (target.getType().isComplexType()) {
                target = target.getField(this.name);
            }
            Object data = this.value;
            if (this.type != null) {
                data = resultSet.getObject(this.value);
            }
            if (target instanceof IBooleanObject) {
                ((IBooleanObject)target).setValue(data);
            } else if (target instanceof IDateObject) {
                if (data instanceof Date) {
                    ((IDateObject)target).setValue((Object)new java.util.Date(((Date)data).getTime()));
                } else if (data instanceof Time) {
                    ((IDateObject)target).setValue((Object)new java.util.Date(((Time)data).getTime()));
                } else if (data instanceof Timestamp) {
                    ((IDateObject)target).setValue((Object)new java.util.Date(((Timestamp)data).getTime()));
                } else {
                    ((IDateObject)target).setValue(data);
                }
            } else if (target instanceof IDecimalObject) {
                ((IDecimalObject)target).setValue(data);
            } else if (target instanceof INumberObject) {
                ((INumberObject)target).setValue(data);
            } else if (target instanceof IStringObject) {
                ((IStringObject)target).setValue(data);
            }
        }
    }
}

