/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.databases.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseConstants;
import org.w3c.dom.Element;

public class DatabaseColumnConfiguration
implements IConfiguration,
DatabaseConstants {
    public static final int TYPE_BIG_DECIMAL = 1;
    public static final int TYPE_BIG_NUMBER = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_DATETIME = 4;
    public static final int TYPE_DECIMAL = 5;
    public static final int TYPE_NUMBER = 6;
    public static final int TYPE_TEXT = 7;
    public static final int TYPE_VARCHAR = 8;
    private String name = "";
    private int type = -1;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void load(Element configurationElement) {
        this.name = configurationElement.getAttribute("name");
        String typeStr = configurationElement.getAttribute("type");
        this.type = "big-decimal".equalsIgnoreCase(typeStr) ? 1 : ("big-number".equalsIgnoreCase(typeStr) ? 2 : ("boolean".equalsIgnoreCase(typeStr) ? 3 : ("datetime".equalsIgnoreCase(typeStr) ? 4 : ("decimal".equalsIgnoreCase(typeStr) ? 5 : ("number".equalsIgnoreCase(typeStr) ? 6 : ("text".equalsIgnoreCase(typeStr) ? 7 : ("varchar".equalsIgnoreCase(typeStr) ? 8 : 0)))))));
    }

    public void save(Element configurationElement) {
        configurationElement.setAttribute("name", this.name);
        switch (this.type) {
            case 1: {
                configurationElement.setAttribute("type", "big-decimal");
                break;
            }
            case 2: {
                configurationElement.setAttribute("type", "big-number");
                break;
            }
            case 3: {
                configurationElement.setAttribute("type", "boolean");
                break;
            }
            case 4: {
                configurationElement.setAttribute("type", "datetime");
                break;
            }
            case 5: {
                configurationElement.setAttribute("type", "decimal");
                break;
            }
            case 6: {
                configurationElement.setAttribute("type", "number");
                break;
            }
            case 7: {
                configurationElement.setAttribute("type", "text");
                break;
            }
            case 8: {
                configurationElement.setAttribute("type", "varchar");
            }
        }
    }
}

