/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.databases.services;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IEncryptionEngine;
import org.eclipse.vtp.framework.core.IProcessContext;
import org.eclipse.vtp.framework.databases.IDatabase;
import org.eclipse.vtp.framework.databases.IDatabaseRegistry;
import org.eclipse.vtp.framework.databases.configurations.DatabaseColumnConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseConfiguration;
import org.eclipse.vtp.framework.databases.configurations.DatabaseTableConfiguration;
import org.eclipse.vtp.framework.databases.configurations.JdbcDatabaseConfiguration;
import org.eclipse.vtp.framework.databases.configurations.JndiDatabaseConfiguration;

public class DatabaseRegistry
implements IDatabaseRegistry {
    private final IProcessContext context;
    private final IEncryptionEngine encryption;
    private final Map<String, IDatabase> databases;

    public DatabaseRegistry(IProcessContext context, IDataTypeRegistry types, DatabaseConfiguration[] configurations) {
        this.context = context;
        Object encryption = context.lookup(IEncryptionEngine.class.getName());
        this.encryption = encryption instanceof IEncryptionEngine ? (IEncryptionEngine)encryption : null;
        HashMap<String, JdbcDatabase> databases = new HashMap<String, JdbcDatabase>(configurations.length);
        int i = 0;
        while (i < configurations.length) {
            block5: {
                AbstractDatabase factory;
                block4: {
                    block3: {
                        factory = null;
                        if (!(configurations[i] instanceof JdbcDatabaseConfiguration)) break block3;
                        factory = new JdbcDatabase(types, (JdbcDatabaseConfiguration)configurations[i]);
                        break block4;
                    }
                    if (!(configurations[i] instanceof JndiDatabaseConfiguration)) break block5;
                    factory = new JndiDatabase(types, (JndiDatabaseConfiguration)configurations[i]);
                }
                databases.put(configurations[i].getName(), (JdbcDatabase)factory);
            }
            ++i;
        }
        this.databases = Collections.unmodifiableMap(databases);
    }

    @Override
    public String[] getDatabaseNames() {
        return this.databases.keySet().toArray(new String[this.databases.size()]);
    }

    @Override
    public IDatabase getDatabase(String databaseName) {
        return this.databases.get(databaseName);
    }

    private abstract class AbstractDatabase
    implements IDatabase {
        final String name;
        final String username;
        final String password;
        final Map<String, Map<String, IDataType>> schema;

        AbstractDatabase(IDataTypeRegistry types, DatabaseConfiguration configuration) {
            this.name = configuration.getName();
            this.username = configuration.getUsername();
            String password = configuration.getPassword();
            this.password = DatabaseRegistry.this.encryption == null || password == null ? password : new String(DatabaseRegistry.this.encryption.decrypt(password.toCharArray()));
            DatabaseTableConfiguration[] tableConfigs = configuration.getTables();
            LinkedHashMap schema = new LinkedHashMap(tableConfigs.length);
            int i = 0;
            while (i < tableConfigs.length) {
                DatabaseColumnConfiguration[] columnConfigs = tableConfigs[i].getColumns();
                LinkedHashMap<String, IDataType> table = new LinkedHashMap<String, IDataType>(columnConfigs.length);
                int j = 0;
                while (j < columnConfigs.length) {
                    String type = null;
                    switch (columnConfigs[j].getType()) {
                        case 1: 
                        case 2: 
                        case 5: {
                            type = "Decimal";
                            break;
                        }
                        case 3: {
                            type = "Boolean";
                            break;
                        }
                        case 4: {
                            type = "Boolean";
                            break;
                        }
                        case 6: {
                            type = "Number";
                            break;
                        }
                        case 7: 
                        case 8: {
                            type = "String";
                        }
                    }
                    if (type != null) {
                        table.put(columnConfigs[j].getName(), types.getDataType(type));
                    }
                    ++j;
                }
                schema.put(tableConfigs[i].getName(), Collections.unmodifiableMap(table));
                ++i;
            }
            this.schema = Collections.unmodifiableMap(schema);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getTableNames() {
            return this.schema.keySet().toArray(new String[this.schema.size()]);
        }

        @Override
        public String[] getColumnNames(String tableName) {
            Map<String, IDataType> table = this.schema.get(tableName);
            if (table == null) {
                return null;
            }
            return table.keySet().toArray(new String[table.size()]);
        }

        @Override
        public IDataType getColumnType(String tableName, String columnName) {
            Map<String, IDataType> table = this.schema.get(tableName);
            if (table == null) {
                return null;
            }
            return table.get(columnName);
        }
    }

    private final class JdbcDatabase
    extends AbstractDatabase {
        final Driver driver;
        final String url;

        JdbcDatabase(IDataTypeRegistry types, JdbcDatabaseConfiguration configuration) {
            super(types, configuration);
            Driver driver = null;
            try {
                driver = (Driver)DatabaseRegistry.this.context.loadClass(configuration.getDriver()).newInstance();
            }
            catch (Exception e) {
                Hashtable<String, Exception> properties = new Hashtable<String, Exception>();
                properties.put("cause", e);
                DatabaseRegistry.this.context.error(e.getMessage(), properties);
            }
            this.driver = driver;
            this.url = configuration.getUrl();
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (this.driver == null) {
                return null;
            }
            Properties info = new Properties();
            if (this.username != null) {
                info.setProperty("user", this.username);
            }
            if (this.password != null) {
                info.setProperty("password", this.password);
            }
            return this.driver.connect(this.url, info);
        }
    }

    private final class JndiDatabase
    extends AbstractDatabase {
        final DataSource dataSource;

        JndiDatabase(IDataTypeRegistry types, JndiDatabaseConfiguration configuration) {
            super(types, configuration);
            DataSource dataSource = null;
            try {
                dataSource = (DataSource)new InitialContext().lookup(configuration.getUri());
            }
            catch (Exception e) {
                Hashtable<String, Exception> properties = new Hashtable<String, Exception>();
                properties.put("cause", e);
                DatabaseRegistry.this.context.error(e.getMessage(), properties);
            }
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (this.dataSource == null) {
                return null;
            }
            if (this.username != null && this.password != null) {
                return this.dataSource.getConnection(this.username, this.password);
            }
            return this.dataSource.getConnection();
        }
    }
}

