/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine;

import java.util.HashSet;

public final class IdentifierDescriptor {
    private final String name;
    private final String[] qualifiers;

    public IdentifierDescriptor(String name, String[] qualifiers) throws IllegalArgumentException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name");
        }
        if (qualifiers == null) {
            throw new NullPointerException("qualifiers");
        }
        this.name = name;
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < qualifiers.length) {
            if (qualifiers[i] == null) {
                throw new NullPointerException("qualifiers[" + i + "]");
            }
            if (!set.add(qualifiers[i])) {
                throw new IllegalArgumentException("qualifiers[" + i + "]");
            }
            ++i;
        }
        this.qualifiers = set.toArray(new String[set.size()]);
    }

    public String getName() {
        return this.name;
    }

    public int getQualifierCount() {
        return this.qualifiers.length;
    }

    public String getQualifier(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.qualifiers.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.qualifiers[index];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)).append('[').append(this.name).append(';');
        int i = 0;
        while (i < this.qualifiers.length) {
            buffer.append(this.qualifiers[i]).append(',');
            ++i;
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.append(']').toString();
    }
}

