/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.http;

import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandRegistry;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.IMapObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.http.DeploymentExecution;
import org.eclipse.vtp.framework.engine.http.ResultDocument;
import org.eclipse.vtp.framework.engine.runtime.Executable;
import org.eclipse.vtp.framework.engine.runtime.Session;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.spi.IProcess;
import org.eclipse.vtp.framework.spi.ISession;
import org.eclipse.vtp.framework.spi.ISessionDescriptor;

public class DeploymentSession
implements ISessionDescriptor {
    private static final String EXECUTION_ID = "execution.id";
    private static final String ROOT_CONTEXT = "root.session.";
    private final String id;
    private final ISession session;
    private HttpSession httpSession = null;
    private String[] qualifier = null;
    private int depth = 0;
    private Date startTime;
    private long timeout = Long.MAX_VALUE;
    private long lastAccessed = System.currentTimeMillis();
    private final boolean[] editLock = new boolean[1];

    private static void assignVariables(IVariableRegistry variableRegistry, Map variables, boolean copy) {
        for (Map.Entry entry : variables.entrySet()) {
            IDataObject variable = DeploymentSession.importVariable(variableRegistry, (Map)entry.getValue(), copy);
            if (variable == null) continue;
            variableRegistry.setVariable((String)entry.getKey(), variable);
        }
    }

    private static IDataObject importVariable(IVariableRegistry variableRegistry, Map data, boolean copy) {
        IDataObject variable;
        block20: {
            if (data == null) {
                return null;
            }
            String typeName = (String)data.get(null);
            if (typeName == null) {
                return null;
            }
            String objectId = (String)data.get("OBJECT_ID");
            variable = variableRegistry.createVariable(typeName, objectId);
            if (variable == null) {
                return null;
            }
            if (!copy) break block20;
            if (variable instanceof IArrayObject) {
                IArrayObject array = (IArrayObject)variable;
                Object[] elements = (Object[])data.get("elements");
                int i = 0;
                while (i < elements.length) {
                    array.addElement(DeploymentSession.importVariable(variableRegistry, (Map)elements[i], true));
                    ++i;
                }
            } else if (variable instanceof IMapObject) {
                IMapObject map = (IMapObject)variable;
                for (String key : data.keySet()) {
                    if (key == null) continue;
                    map.setField(key, DeploymentSession.importVariable(variableRegistry, (Map)data.get(key), true));
                }
            } else if (variable instanceof IBooleanObject) {
                ((IBooleanObject)variable).setValue(data.get("value"));
            } else if (variable instanceof IDateObject) {
                ((IDateObject)variable).setValue(data.get("value"));
            } else if (variable instanceof IDecimalObject) {
                ((IDecimalObject)variable).setValue(data.get("value"));
            } else if (variable instanceof INumberObject) {
                ((INumberObject)variable).setValue(data.get("value"));
            } else if (variable instanceof IStringObject) {
                ((IStringObject)variable).setValue(data.get("value"));
            } else {
                String[] fields = variable.getType().getFieldNames();
                int i = 0;
                while (i < fields.length) {
                    variable.setField(fields[i], DeploymentSession.importVariable(variableRegistry, (Map)data.get(fields[i]), copy));
                    ++i;
                }
            }
        }
        return variable;
    }

    DeploymentSession(String id, IProcess process) {
        this.id = id;
        this.session = process.createSession((ISessionDescriptor)this);
    }

    public String getCurrentPosition() {
        Executable executable = ((Session)this.session).process.blueprint.getExecutable((String)this.getAttribute("engine.sequence.position"));
        if (executable == null) {
            return null;
        }
        return executable.getActionInstance().getName();
    }

    public IVariableRegistry getVariableRegistry() {
        return (IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        while (true) {
            try {
                boolean[] blArray = this.editLock;
                synchronized (this.editLock) {
                    if (this.editLock[0]) {
                        this.editLock.wait(60000L);
                    }
                    if (this.editLock[0]) {
                        throw new RuntimeException("Timed out trying to lock session.");
                    }
                    this.editLock[0] = true;
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        boolean[] blArray = this.editLock;
        synchronized (this.editLock) {
            this.editLock[0] = false;
            this.editLock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ISession getSession() {
        return this.session;
    }

    public ResultDocument start(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, int depth, Map variableValues, Map parameterValues, String entryName, String brand, boolean subdialog) {
        this.httpSession = httpSession;
        this.timeout = (long)httpSession.getMaxInactiveInterval() * 1000L;
        this.lastAccessed = httpSession.getLastAccessedTime();
        this.depth = depth;
        this.qualifier = new String[depth + 1];
        int i = 0;
        while (i <= depth) {
            this.qualifier[i] = String.valueOf(prefix) + i + ".";
            ++i;
        }
        DeploymentSession.assignVariables((IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName()), variableValues, false);
        IBrandRegistry brands = (IBrandRegistry)this.session.lookupService(IBrandRegistry.class.getName());
        IBrand selectedBrand = brands.getBrand(brand);
        if (selectedBrand != null) {
            ((IBrandSelection)this.session.lookupService(IBrandSelection.class.getName())).setSelectedBrand(selectedBrand);
        } else {
            selectedBrand = brands.getDefaultBrand();
        }
        IVariableRegistry variables = (IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName());
        IDataObject platform = variables.createVariable("Platform");
        ((IStringObject)platform.getField("Brand")).setValue((Object)selectedBrand.getName());
        if (httpRequest.getParameter("PLATFORM_ANI") != null) {
            ((IStringObject)platform.getField("PLATFORM_ANI")).setValue((Object)httpRequest.getParameter("PLATFORM_ANI"));
            ((IStringObject)platform.getField("ANI")).setValue((Object)httpRequest.getParameter("PLATFORM_ANI"));
        }
        if (httpRequest.getParameter("PLATFORM_DNIS") != null) {
            ((IStringObject)platform.getField("PLATFORM_DNIS")).setValue((Object)httpRequest.getParameter("PLATFORM_DNIS"));
            ((IStringObject)platform.getField("DNIS")).setValue((Object)httpRequest.getParameter("PLATFORM_DNIS"));
        }
        variables.setVariable("Platform", platform);
        IReporter reporter = (IReporter)this.session.lookupService(IReporter.class.getName());
        if (reporter.isReportingEnabled()) {
            Hashtable<String, String> report = new Hashtable<String, String>();
            ((Dictionary)report).put("event", "session.created");
            reporter.report(3, "Session \"" + this.id + "\" created.", report);
        }
        this.startTime = (Date)this.getAttribute("session.starttime");
        if (this.startTime == null) {
            this.startTime = new Date();
            this.setAttribute("session.starttime", this.startTime);
        }
        this.setAttribute("engine.sequence.entry", entryName);
        this.setAttribute("subdialog", subdialog ? "true" : "false");
        return new DeploymentExecution(this.getNextExecutionID(), this, httpRequest, httpReesponse, parameterValues).doNext();
    }

    public ResultDocument next(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, int depth, Map variableValues, Map parameterValues) {
        this.httpSession = httpSession;
        this.timeout = (long)httpSession.getMaxInactiveInterval() * 1000L;
        this.lastAccessed = httpSession.getLastAccessedTime();
        this.depth = depth;
        this.qualifier = new String[depth + 1];
        int i = 0;
        while (i <= depth) {
            this.qualifier[i] = String.valueOf(prefix) + i + ".";
            ++i;
        }
        DeploymentSession.assignVariables((IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName()), variableValues, true);
        this.startTime = (Date)this.getAttribute("session.starttime");
        if (this.startTime == null) {
            this.startTime = new Date();
            this.setAttribute("session.starttime", this.startTime);
        }
        return new DeploymentExecution(this.getNextExecutionID(), this, httpRequest, httpReesponse, parameterValues).doNext();
    }

    public IDocument abort(HttpSession httpSession, HttpServletRequest httpRequest, HttpServletResponse httpReesponse, String prefix, int depth, Map variableValues, Map parameterValues) {
        this.httpSession = httpSession;
        this.depth = depth;
        this.qualifier = new String[depth + 1];
        int i = 0;
        while (i <= depth) {
            this.qualifier[i] = String.valueOf(prefix) + i + ".";
            ++i;
        }
        try {
            DeploymentSession.assignVariables((IVariableRegistry)this.session.lookupService(IVariableRegistry.class.getName()), variableValues, true);
            IDocument iDocument = new DeploymentExecution(this.getNextExecutionID(), this, httpRequest, httpReesponse, parameterValues).doAbort();
            return iDocument;
        }
        finally {
            this.fireDisposedEvent(httpSession);
            httpSession.setAttribute("vtp.supressSessionDisposedEvent", (Object)Boolean.TRUE);
            if (!"true".equals(this.getAttribute("fragment"))) {
                httpSession.invalidate();
            }
        }
    }

    public void fireDisposedEvent(HttpSession httpSession) {
        if (httpSession.getAttribute("vtp.supressSessionDisposedEvent") == Boolean.TRUE) {
            return;
        }
        IReporter reporter = (IReporter)this.session.lookupService(IReporter.class.getName());
        if (reporter.isReportingEnabled()) {
            Hashtable<String, String> report = new Hashtable<String, String>();
            ((Dictionary)report).put("event", "session.disposed");
            reporter.report(3, "Session \"" + this.id + "\" disposed.", report);
        }
    }

    private String getNextExecutionID() {
        Object executionID = this.httpSession.getAttribute(this.qualifier + EXECUTION_ID);
        if (!(executionID instanceof Integer)) {
            executionID = new Integer(0);
        }
        executionID = new Integer((Integer)executionID + 1);
        this.httpSession.setAttribute(this.qualifier + EXECUTION_ID, executionID);
        return executionID.toString();
    }

    public String getSessionID() {
        return this.id;
    }

    public Date getSessionStartTime() {
        return this.startTime;
    }

    public String[] getServiceIdentifiers() {
        return new String[0];
    }

    public Object getService(String identifier) throws NullPointerException {
        return null;
    }

    public String[] getAttributeNames() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.httpSession != null) {
            Enumeration e = this.httpSession.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith(this.qualifier[this.depth])) continue;
                list.add(name.substring(this.qualifier[this.depth].length()));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public Object getAttribute(String attributeName) throws NullPointerException {
        if (this.httpSession == null || attributeName == null) {
            return null;
        }
        Object obj = null;
        if (attributeName.startsWith("variable")) {
            int i = this.depth;
            while (i > -1) {
                obj = this.httpSession.getAttribute(String.valueOf(this.qualifier[i]) + attributeName);
                if (obj != null) break;
                --i;
            }
            if (obj == null) {
                Enumeration e = this.httpSession.getAttributeNames();
                while (e.hasMoreElements()) {
                    String string = (String)e.nextElement();
                }
            }
        } else {
            obj = this.httpSession.getAttribute(String.valueOf(this.qualifier[this.depth]) + attributeName);
        }
        return obj;
    }

    public void setAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        if (this.httpSession != null) {
            this.httpSession.setAttribute(String.valueOf(this.qualifier[this.depth]) + attributeName, attributeValue);
        }
    }

    public void clearAttribute(String attributeName) throws NullPointerException {
        if (this.httpSession != null) {
            this.httpSession.removeAttribute(String.valueOf(this.qualifier[this.depth]) + attributeName);
        }
    }

    public boolean isValid() {
        return System.currentTimeMillis() - this.lastAccessed < this.timeout;
    }

    public String[] getRootAttributeNames() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.httpSession != null) {
            Enumeration e = this.httpSession.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith(ROOT_CONTEXT)) continue;
                list.add(name.substring(ROOT_CONTEXT.length()));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public Object getRootAttribute(String attributeName) throws NullPointerException {
        return this.httpSession == null ? null : this.httpSession.getAttribute(ROOT_CONTEXT + attributeName);
    }

    public void setRootAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        if (this.httpSession != null) {
            this.httpSession.setAttribute(ROOT_CONTEXT + attributeName, attributeValue);
        }
    }

    public void clearRootAttribute(String attributeName) throws NullPointerException {
        if (this.httpSession != null) {
            this.httpSession.removeAttribute(ROOT_CONTEXT + attributeName);
        }
    }
}

