/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.eclipse.vtp.framework.common.IArrayObject;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IReporter;
import org.eclipse.vtp.framework.engine.ResourceGroup;
import org.eclipse.vtp.framework.engine.http.ControllerDocument;
import org.eclipse.vtp.framework.engine.http.Deployment;
import org.eclipse.vtp.framework.engine.http.DeploymentSession;
import org.eclipse.vtp.framework.engine.http.HttpConnectorContext;
import org.eclipse.vtp.framework.engine.http.HttpConnectorServlet;
import org.eclipse.vtp.framework.engine.http.HttpUtils;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.spi.IProcessDefinition;
import org.eclipse.vtp.framework.spi.IProcessEngine;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.log.LogService;

public class HttpConnector {
    public static final String PATH_PREFIX = "/-/";
    public static final String ABORT_PATH = "/-/abort";
    public static final String INDEX_PATH = "/-/index";
    public static final String NEXT_PATH = "/-/next";
    public static final String RESOURCES_PATH = "/-/resources";
    public static final String EXAMINE_PATH = "/-/examine";
    public static final String LOG_PATH = "/-/logging";
    private static final String MIME_TYPE_PREFIX = "mime.type.";
    private static final String DEPLOYMENT_ID = "deployment.id";
    private static final String ENTRY_POINT_NAME = "entry.point.name";
    private static final Comparator<String> PATH_SORT = new Comparator<String>(){

        @Override
        public int compare(String left, String right) {
            int difference = right.length() - left.length();
            if (difference == 0) {
                difference = left.compareTo(right);
            }
            return difference;
        }
    };
    private final IProcessEngine engine;
    private final HttpService httpService;
    private final IReporter reporter;
    private final Map<String, IProcessDefinition> definitionsByID = new HashMap<String, IProcessDefinition>();
    private final Map<String, Bundle> definitionContributors = new HashMap<String, Bundle>();
    private final Map<String, ResourceGroup> resourcesByID = new HashMap<String, ResourceGroup>();
    private Dictionary properties = null;
    private String servletPath = null;
    private String resourcesPath = null;
    private boolean open = false;
    private final Map<String, Deployment> deploymentsByKey = new HashMap<String, Deployment>();
    private final Map<String, Deployment> deploymentsByID = new HashMap<String, Deployment>();
    private final Map<String, Deployment> deploymentsByPath = new TreeMap<String, Deployment>(PATH_SORT);

    public HttpConnector(LogService log, IProcessEngine engine, HttpService httpService, IReporter reporter) {
        this.engine = engine;
        this.httpService = httpService;
        this.reporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDefinition(String definitionID, IProcessDefinition definition, Bundle contributor) {
        Map<String, IProcessDefinition> map = this.definitionsByID;
        synchronized (map) {
            this.definitionsByID.put(definitionID, definition);
            this.definitionContributors.put(definitionID, contributor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDefinition(String definitionID) {
        Map<String, IProcessDefinition> map = this.definitionsByID;
        synchronized (map) {
            this.definitionContributors.remove(definitionID);
            this.definitionsByID.remove(definitionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResouces(String resourcesID, ResourceGroup resources) {
        Map<String, ResourceGroup> map = this.resourcesByID;
        synchronized (map) {
            this.resourcesByID.put(resourcesID, resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResouces(String resourcesID) {
        Map<String, ResourceGroup> map = this.resourcesByID;
        synchronized (map) {
            this.resourcesByID.remove(resourcesID);
        }
    }

    public synchronized void configure(Dictionary properties) {
        this.close();
        this.properties = properties;
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deploy(String key, Dictionary properties) {
        Deployment deployment = this.deploymentsByKey.remove(key);
        if (deployment != null) {
            this.deploymentsByPath.remove(deployment.getPath());
        }
        String definitionID = (String)properties.get("definition.id");
        String deploymentID = (String)properties.get(DEPLOYMENT_ID);
        String path = (String)properties.get("path");
        IProcessDefinition definition = null;
        Bundle contributor = null;
        Map<String, Object> map = this.definitionsByID;
        synchronized (map) {
            definition = this.definitionsByID.get(definitionID);
            contributor = this.definitionContributors.get(definitionID);
        }
        if (definition == null) {
            try {
                Thread.sleep(15000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            map = this.definitionsByID;
            synchronized (map) {
                definition = this.definitionsByID.get(definitionID);
                contributor = this.definitionContributors.get(definitionID);
            }
        }
        if (definition == null || contributor == null) {
            return;
        }
        try {
            deployment = new Deployment(this.engine, definition, properties, contributor, this.reporter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        map = this.resourcesByID;
        synchronized (map) {
            for (Map.Entry<String, ResourceGroup> entry : this.resourcesByID.entrySet()) {
                deployment.setResourceManager(entry.getKey(), entry.getValue());
            }
        }
        if (deploymentID == null) {
            return;
        }
        if (this.deploymentsByID.containsKey(deploymentID)) {
            return;
        }
        this.deploymentsByKey.put(key, deployment);
        this.deploymentsByID.put(deploymentID, deployment);
        if (path == null) {
            return;
        }
        this.deploymentsByPath.put(path, deployment);
    }

    public synchronized void undeploy(String key) {
        Deployment deployment = this.deploymentsByKey.remove(key);
        if (deployment == null) {
            return;
        }
        this.deploymentsByPath.remove(deployment.getPath());
        deployment.dispose();
    }

    public synchronized void examine(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String cmd = req.getParameter("cmd");
        String process = req.getParameter("process");
        String session = req.getParameter("session");
        String variable = req.getParameter("variable");
        String action = req.getParameter("action");
        String value = req.getParameter("value");
        Deployment deployment = null;
        if (process != null) {
            deployment = this.deploymentsByPath.get(process);
        }
        DeploymentSession deploymentSession = null;
        if (session != null) {
            deploymentSession = deployment.getActiveSession(session);
        }
        IDataObject parent = null;
        IDataObject object = null;
        String fieldName = null;
        if (variable != null) {
            String[] stringArray = variable.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (object == null) {
                    object = deploymentSession.getVariableRegistry().getVariable(token);
                } else {
                    parent = object;
                    object = parent.getField(token);
                }
                fieldName = token;
                ++n2;
            }
        }
        if ("unlock".equals(cmd)) {
            if (action.startsWith("Save")) {
                IVariableRegistry variables = deploymentSession.getVariableRegistry();
                if (object == null) {
                    object = variables.createVariable(parent.getField(fieldName).getType());
                    parent.setField(fieldName, object);
                }
                if (object instanceof IBooleanObject) {
                    ((IBooleanObject)object).setValue((Object)value);
                } else if (object instanceof IDateObject) {
                    ((IDateObject)object).setValue((Object)value);
                } else if (object instanceof IDecimalObject) {
                    ((IDecimalObject)object).setValue((Object)value);
                } else if (object instanceof INumberObject) {
                    ((INumberObject)object).setValue((Object)value);
                } else if (object instanceof IStringObject) {
                    ((IStringObject)object).setValue((Object)value);
                }
            }
            deploymentSession.unlock();
            res.sendRedirect(res.encodeRedirectURL("examine?cmd=variables&process=" + process + "&session=" + session));
        } else {
            String base = res.encodeURL("examine?cmd=");
            res.setContentType("text/html");
            ServletOutputStream out = res.getOutputStream();
            out.println("<html><head><title>Runtime Examination</title></head><body>");
            if ("edit".equals(cmd)) {
                out.println("<p>Application: " + process + "</p>");
                out.println("<p>Session: " + deploymentSession.getSessionID() + " : " + deploymentSession.getCurrentPosition() + "</p>");
                deploymentSession.lock();
                out.println("<form action=\"examine\" method=\"post\">");
                out.println("<input type=\"hidden\" name=\"cmd\" value=\"unlock\" />");
                out.println("<input type=\"hidden\" name=\"process\" value=\"" + process + "\" />");
                out.println("<input type=\"hidden\" name=\"session\" value=\"" + session + "\" />");
                out.println("<input type=\"hidden\" name=\"variable\" value=\"" + variable + "\" />");
                out.println("<p>" + variable + " = ");
                out.println("<input type=\"text\" name=\"value\" value=\"");
                if (object != null) {
                    out.println(object.toString());
                }
                out.println("\" /></p>");
                out.println("<p><input type=\"submit\" name=\"action\" value=\"Save & Unlock\" />&nbsp;");
                out.println("<input type=\"submit\" name=\"action\" value=\"Cancel & Unlock\" /></p>");
                out.println("</form>");
            } else if ("variables".equals(cmd)) {
                out.println("<p>Application: " + process + "</p>");
                out.println("<p>Session: " + deploymentSession.getSessionID() + " : " + deploymentSession.getCurrentPosition() + "</p>");
                out.println("<p>Select a variable to edit:</p><ul>");
                IVariableRegistry iVariableRegistry = deploymentSession.getVariableRegistry();
                String prefix = String.valueOf(base) + "edit&process=" + process + "&session=" + session + "&variable=";
                Object[] variableNames = iVariableRegistry.getVariableNames();
                Arrays.sort(variableNames);
                Object[] objectArray = variableNames;
                int n = variableNames.length;
                int n3 = 0;
                while (n3 < n) {
                    Object name = objectArray[n3];
                    this.examineVariable(out, prefix, (String)name, iVariableRegistry.getVariable((String)name));
                    ++n3;
                }
                out.println("</ul>");
            } else if ("sessions".equals(cmd)) {
                out.println("<p>Application: " + process + "</p>");
                out.println("<p>Select the session to examine:</p><ul>");
                DeploymentSession[] deploymentSessionArray = deployment.getActiveSessions();
                int n = deploymentSessionArray.length;
                int n4 = 0;
                while (n4 < n) {
                    DeploymentSession deploymentSession2 = deploymentSessionArray[n4];
                    out.print("<li><a href=\"");
                    out.print(base);
                    out.print("variables&process=");
                    out.print(process);
                    out.print("&session=");
                    out.print(deploymentSession2.getSessionID());
                    out.print("\">");
                    out.print(deploymentSession2.getSessionID());
                    out.print(" : ");
                    out.print(deploymentSession2.getCurrentPosition());
                    out.println("</a></li>");
                    ++n4;
                }
                out.println("</ul>");
            } else {
                out.println("<p>Select the application to examine:</p><ul>");
                for (Object e : this.deploymentsByPath.keySet()) {
                    out.print("<li><a href=\"");
                    out.print(base);
                    out.print("sessions&process=");
                    out.print(e.toString());
                    out.print("\">");
                    out.print(e.toString());
                    out.println("</a></li>");
                }
                out.println("</ul>");
            }
            out.println("</body></html>");
        }
    }

    private void examineVariable(ServletOutputStream out, String prefix, String name, IDataObject var) throws IOException {
        if (var instanceof IBooleanObject || var instanceof IDateObject || var instanceof IDecimalObject || var instanceof INumberObject || var instanceof IStringObject) {
            out.print("<li>");
            out.print(name);
            out.print(" = ");
            out.print(var.toString());
            out.print("&nbsp;&nbsp;<a href=\"");
            out.print(prefix);
            out.print(name);
            out.print("\">Lock & Edit</a></li>");
        } else if (!(var instanceof IArrayObject)) {
            Object[] fieldNames = var.getType().getFieldNames();
            Arrays.sort(fieldNames);
            Object[] objectArray = fieldNames;
            int n = fieldNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object fieldName = objectArray[n2];
                this.examineVariable(out, prefix, String.valueOf(name) + "." + (String)fieldName, var.getField((String)fieldName));
                ++n2;
            }
        }
    }

    public void process(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.invokeProcessEngine(req, res, req.getSession(), HttpUtils.normalizePath(req.getPathInfo()), Collections.<Object, Object>emptyMap(), Collections.EMPTY_MAP, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeProcessEngine(HttpServletRequest req, HttpServletResponse res, HttpSession httpSession, String pathInfo, Map<Object, Object> variableValues, Map parameterValues, boolean embeddedInvocation) throws IOException, ServletException {
        boolean newSession = false;
        Integer depth = (Integer)httpSession.getAttribute("connector.depth");
        if (depth == null) {
            depth = new Integer(0);
        }
        String prefix = "connector.attributes.";
        String fullPrefix = String.valueOf(prefix) + depth + ".";
        if (embeddedInvocation) {
            httpSession.setAttribute(String.valueOf(fullPrefix) + "fragment", (Object)"true");
        }
        Deployment deployment = null;
        String brand = null;
        String entryName = null;
        boolean subdialog = false;
        if (!pathInfo.startsWith(PATH_PREFIX)) {
            newSession = true;
            HttpConnector httpConnector = this;
            synchronized (httpConnector) {
                for (String string : this.deploymentsByPath.keySet()) {
                    if (!pathInfo.equals(string) && (!pathInfo.startsWith(string) || pathInfo.length() <= string.length() || pathInfo.charAt(string.length()) != '/')) continue;
                    deployment = this.deploymentsByPath.get(string);
                    brand = req.getParameter("BRAND");
                    if (req.getParameter("SUBDIALOG") != null) {
                        subdialog = Boolean.parseBoolean(req.getParameter("SUBDIALOG"));
                    }
                    if (pathInfo.length() <= string.length() + 1) break;
                    entryName = pathInfo.substring(string.length() + 1);
                    break;
                }
            }
            if (deployment == null) {
                res.sendError(404);
                return;
            }
            if (entryName == null) {
                res.sendError(403);
                return;
            }
            pathInfo = NEXT_PATH;
            httpSession.setAttribute(String.valueOf(fullPrefix) + DEPLOYMENT_ID, (Object)deployment.getProcessID());
        } else {
            if (pathInfo.equals(LOG_PATH)) {
                if (req.getParameter("cmd") != null && req.getParameter("cmd").equals("set")) {
                    String level = req.getParameter("level");
                    if (level == null || !level.equalsIgnoreCase("ERROR") && !level.equalsIgnoreCase("WARN") && !level.equalsIgnoreCase("INFO") && !level.equalsIgnoreCase("DEBUG")) {
                        level = "INFO";
                    }
                    System.setProperty("org.eclipse.vtp.loglevel", level);
                }
                this.writeLogging(req, res);
                return;
            }
            String deploymentID = (String)httpSession.getAttribute(String.valueOf(fullPrefix) + DEPLOYMENT_ID);
            HttpConnector httpConnector = this;
            synchronized (httpConnector) {
                deployment = this.deploymentsByID.get(deploymentID);
            }
            if (deployment == null) {
                res.sendError(403);
                return;
            }
        }
        if (subdialog) {
            httpSession.setAttribute(String.valueOf(fullPrefix) + "subdialog", (Object)"true");
        }
        if (pathInfo.equals(INDEX_PATH)) {
            this.writeIndex(res, deployment);
            return;
        }
        IDocument document = null;
        if (pathInfo.equals(ABORT_PATH)) {
            document = deployment.abort(httpSession, req, res, prefix, depth, variableValues, parameterValues);
        } else if (pathInfo.equals(NEXT_PATH)) {
            document = brand == null && !newSession ? deployment.next(httpSession, req, res, prefix, depth, variableValues, parameterValues) : deployment.start(httpSession, req, res, prefix, depth, variableValues, parameterValues, entryName, brand, subdialog);
        } else {
            res.sendError(404);
            return;
        }
        if (document == null) {
            res.setStatus(204);
            return;
        }
        if (document instanceof ControllerDocument) {
            ControllerDocument controllerDocument = (ControllerDocument)document;
            if (controllerDocument.getTarget() == null) {
                Map map;
                Map outgoing = (Map)httpSession.getAttribute(String.valueOf(fullPrefix) + "outgoing-data");
                int newDepth = depth - 1;
                if (newDepth == 0) {
                    httpSession.removeAttribute("connector.depth");
                } else {
                    httpSession.setAttribute("connector.depth", (Object)new Integer(newDepth));
                }
                String oldFullPrefix = fullPrefix;
                fullPrefix = String.valueOf(prefix) + newDepth + ".";
                Object[] params = (Object[])httpSession.getAttribute(String.valueOf(fullPrefix) + "exitparams");
                HashMap<Object, Object> parameters = new HashMap<Object, Object>();
                if (params != null) {
                    int i = 0;
                    while (i < params.length) {
                        parameters.put(params[i], params[i + 1]);
                        i += 2;
                    }
                }
                String[] paramNames = controllerDocument.getParameterNames();
                int i = 0;
                while (i < paramNames.length) {
                    parameters.put(paramNames[i], controllerDocument.getParameterValues(paramNames[i]));
                    ++i;
                }
                String[] variableNames = controllerDocument.getVariableNames();
                HashMap<Object, Object> variables = new HashMap<Object, Object>(variableNames.length);
                if (outgoing != null && (map = (Map)outgoing.get(controllerDocument.getParameterValues("exit")[0])) != null) {
                    int i2 = 0;
                    while (i2 < variableNames.length) {
                        Object mapping = map.get(variableNames[i2]);
                        if (mapping != null) {
                            variables.put(mapping, controllerDocument.getVariableValue(variableNames[i2]));
                        }
                        ++i2;
                    }
                }
                Enumeration e = httpSession.getAttributeNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (!name.startsWith(oldFullPrefix)) continue;
                    httpSession.removeAttribute(name);
                }
                deployment.end(httpSession);
                this.invokeProcessEngine(req, res, httpSession, NEXT_PATH, variables, parameters, newDepth > 0);
                return;
            }
            String[] paramNames = controllerDocument.getParameterNames();
            Object[] params = new Object[paramNames.length * 2];
            int i = 0;
            while (i < params.length) {
                params[i] = paramNames[i / 2];
                params[i + 1] = controllerDocument.getParameterValues(paramNames[i / 2]);
                i += 2;
            }
            httpSession.setAttribute(String.valueOf(fullPrefix) + "exitparams", (Object)params);
            String[] variableNames = controllerDocument.getVariableNames();
            HashMap<Object, Object> variables = new HashMap<Object, Object>(variableNames.length);
            int i3 = 0;
            while (i3 < variableNames.length) {
                variables.put(variableNames[i3], controllerDocument.getVariableValue(variableNames[i3]));
                ++i3;
            }
            httpSession.setAttribute("connector.depth", (Object)new Integer(depth + 1));
            fullPrefix = String.valueOf(prefix) + (depth + 1) + ".";
            String deploymentId = controllerDocument.getTarget().substring(0, controllerDocument.getTarget().lastIndexOf(40) - 1);
            String entryPointName = controllerDocument.getTarget().substring(controllerDocument.getTarget().lastIndexOf(40) + 1, controllerDocument.getTarget().length() - 1);
            httpSession.setAttribute(String.valueOf(fullPrefix) + DEPLOYMENT_ID, (Object)deploymentId);
            httpSession.setAttribute(String.valueOf(fullPrefix) + ENTRY_POINT_NAME, (Object)entryPointName);
            HashMap outgoing = new HashMap();
            String[] outPaths = controllerDocument.getOutgoingPaths();
            int i4 = 0;
            while (i4 < outPaths.length) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String[] names = controllerDocument.getOutgoingDataNames(outPaths[i4]);
                int j = 0;
                while (j < names.length) {
                    map.put(names[j], controllerDocument.getOutgoingDataValue(outPaths[i4], names[j]));
                    ++j;
                }
                outgoing.put(outPaths[i4], map);
                ++i4;
            }
            httpSession.setAttribute(String.valueOf(fullPrefix) + "outgoing-data", outgoing);
            this.invokeProcessEngine(req, res, httpSession, "/" + deploymentId + "/" + entryPointName, variables, Collections.EMPTY_MAP, true);
            return;
        }
        res.setStatus(200);
        if (!document.isCachable()) {
            res.setHeader("Cache-Control", "max-age=0, no-cache");
        }
        res.setContentType(document.getContentType());
        ServletOutputStream servletOutputStream = res.getOutputStream();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            XMLWriter xmlWriter = new XMLWriter((OutputStream)servletOutputStream);
            xmlWriter.setCompactElements(true);
            transformer.transform(document.toXMLSource(), xmlWriter.toXMLResult());
            if (this.reporter.isSeverityEnabled(3) && !document.isSecured()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                xmlWriter = new XMLWriter((OutputStream)baos);
                xmlWriter.setCompactElements(true);
                transformer.transform(document.toXMLSource(), xmlWriter.toXMLResult());
                System.out.println(new String(baos.toByteArray(), "UTF-8"));
            }
        }
        catch (TransformerException e) {
            throw new ServletException((Throwable)e);
        }
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    public String getMimeType(String resourcePath) {
        Dictionary properties = this.properties;
        if (properties == null) {
            return null;
        }
        if (resourcePath == null || properties.isEmpty()) {
            return null;
        }
        int lastSlash = resourcePath.lastIndexOf(47);
        if (lastSlash >= 0) {
            resourcePath = resourcePath.substring(lastSlash + 1);
        }
        if (resourcePath.length() == 0) {
            return null;
        }
        Object mimeType = properties.get(MIME_TYPE_PREFIX + resourcePath);
        while (!(mimeType instanceof String)) {
            int firstDot = resourcePath.indexOf(46);
            if (firstDot < 0) {
                return null;
            }
            resourcePath = resourcePath.substring(firstDot + 1);
            mimeType = properties.get(MIME_TYPE_PREFIX + resourcePath);
        }
        return (String)mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String resourcePath) {
        String normal = HttpUtils.normalizePath(resourcePath).substring(1);
        int firstSlash = normal.indexOf(47);
        if (firstSlash < 0) {
            return null;
        }
        String resourcesID = normal.substring(0, firstSlash);
        ResourceGroup resources = null;
        Map<String, ResourceGroup> map = this.resourcesByID;
        synchronized (map) {
            resources = this.resourcesByID.get(resourcesID);
        }
        if (resources == null) {
            return null;
        }
        return resources.getResource(normal.substring(firstSlash + 1));
    }

    private void open() {
        if (this.open) {
            return;
        }
        try {
            try {
                String servletPath = null;
                String resourcesPath = null;
                Object path = this.properties == null ? null : this.properties.get("path");
                servletPath = path instanceof String ? HttpUtils.normalizePath(path) : "/";
                resourcesPath = "/".equals(servletPath) ? RESOURCES_PATH : String.valueOf(servletPath) + RESOURCES_PATH;
                HttpConnectorContext context = new HttpConnectorContext(this.httpService.createDefaultHttpContext(), this);
                this.httpService.registerResources(resourcesPath, "/", (HttpContext)context);
                this.resourcesPath = resourcesPath;
                this.httpService.registerServlet(servletPath, (Servlet)new HttpConnectorServlet(this), null, (HttpContext)context);
                this.servletPath = servletPath;
                this.open = true;
            }
            catch (NamespaceException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ServletException e) {
                throw new IllegalArgumentException(e);
            }
        }
        finally {
            if (!this.open && this.resourcesPath != null) {
                String resourcesPath = this.resourcesPath;
                this.resourcesPath = null;
                this.httpService.unregister(resourcesPath);
            }
        }
    }

    private void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        try {
            if (this.servletPath != null) {
                this.httpService.unregister(this.servletPath);
            }
        }
        finally {
            this.servletPath = null;
            try {
                if (this.resourcesPath != null) {
                    this.httpService.unregister(this.resourcesPath);
                }
            }
            finally {
                this.resourcesPath = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(HttpServletResponse res, Deployment deployment) throws IOException {
        String deploymentID = deployment.getID();
        res.setStatus(200);
        res.setContentType("text/html");
        PrintWriter writer = res.getWriter();
        writer.println("<html>");
        writer.println("<head><title>Deployments</title></head>");
        writer.println("<body>");
        if (deploymentID != null) {
            writer.print("<p>CURRENT: ");
            writer.print(deploymentID);
            writer.println("</p>");
        }
        HttpConnector httpConnector = this;
        synchronized (httpConnector) {
            for (Map.Entry<String, Deployment> entry : this.deploymentsByPath.entrySet()) {
                writer.print("<p><a href=\"");
                writer.print(res.encodeURL(entry.getKey()));
                writer.print("\">");
                writer.print(entry.getValue().getProcessID());
                writer.println("</a></p>");
            }
        }
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
        writer.close();
    }

    private void writeLogging(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String servletPath;
        res.setStatus(200);
        res.setContentType("text/html");
        PrintWriter writer = res.getWriter();
        writer.println("<html>");
        writer.println("<head><title>Logging Level</title></head>");
        writer.println("<body>");
        writer.print("<p>Current Log Level: " + System.getProperty("org.eclipse.vtp.loglevel", "INFO"));
        writer.println("</p>");
        StringBuffer buffer = new StringBuffer();
        String contextPath = HttpUtils.normalizePath(req.getContextPath());
        if (!contextPath.equals("/")) {
            buffer.append(contextPath);
        }
        if (!(servletPath = HttpUtils.normalizePath(req.getServletPath())).equals("/")) {
            buffer.append(servletPath);
        }
        buffer.append(LOG_PATH);
        writer.println("<form action=\"" + buffer.toString() + "\">");
        writer.println("<input type=\"hidden\" name=\"cmd\" value=\"set\"/>");
        writer.println("New Level <select name=\"level\">");
        writer.println("<option>ERROR</option>");
        writer.println("<option>WARN</option>");
        writer.println("<option selected>INFO</option>");
        writer.println("<option>DEBUG</option>");
        writer.println("</select>");
        writer.println("<input type=\"submit\" value=\"Set\"/>");
        writer.println("</form>");
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
        writer.close();
    }
}

