/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.vtp.framework.core.IContext;
import org.eclipse.vtp.framework.engine.ActionDescriptor;
import org.eclipse.vtp.framework.engine.ConfigurationDescriptor;
import org.eclipse.vtp.framework.engine.ObserverDescriptor;
import org.eclipse.vtp.framework.engine.ServiceDescriptor;
import org.eclipse.vtp.framework.engine.runtime.Action;
import org.eclipse.vtp.framework.engine.runtime.Configurable;
import org.eclipse.vtp.framework.engine.runtime.Configuration;
import org.eclipse.vtp.framework.engine.runtime.Executable;
import org.eclipse.vtp.framework.engine.runtime.Observer;
import org.eclipse.vtp.framework.engine.runtime.RuntimeUtils;
import org.eclipse.vtp.framework.engine.runtime.Service;
import org.eclipse.vtp.framework.spi.IProcessDefinition;
import org.w3c.dom.Element;

public class Blueprint {
    private final Map configurationIndex;
    private final Map processServiceIndex;
    private final Map sessionServiceIndex;
    private final Map executionServiceIndex;
    private final Map actionServiceIndex;
    private final Map executableIndex;
    private final Map<String, Executable> entryPointIndex;
    private final IExtensionRegistry registry;

    public Blueprint(IProcessDefinition definition, ConfigurationDescriptor[] configurationDescriptors, ActionDescriptor[] actionDescriptors, ObserverDescriptor[] observerDescriptors, ServiceDescriptor[] serviceDescriptors, IExtensionRegistry registry) {
        this.configurationIndex = this.indexConfigurations(configurationDescriptors);
        ArrayList<ServiceDescriptor> processServiceDescriptors = new ArrayList<ServiceDescriptor>(serviceDescriptors.length);
        ArrayList<ServiceDescriptor> sessionServiceDescriptors = new ArrayList<ServiceDescriptor>(serviceDescriptors.length);
        ArrayList<ServiceDescriptor> executionServiceDescriptors = new ArrayList<ServiceDescriptor>(serviceDescriptors.length);
        ArrayList<ServiceDescriptor> actionServiceDescriptors = new ArrayList<ServiceDescriptor>(serviceDescriptors.length);
        int i = 0;
        while (i < serviceDescriptors.length) {
            if ("process".equals(serviceDescriptors[i].getScope())) {
                processServiceDescriptors.add(serviceDescriptors[i]);
            } else if ("session".equals(serviceDescriptors[i].getScope())) {
                sessionServiceDescriptors.add(serviceDescriptors[i]);
            } else if ("execution".equals(serviceDescriptors[i].getScope())) {
                executionServiceDescriptors.add(serviceDescriptors[i]);
            } else if ("action".equals(serviceDescriptors[i].getScope())) {
                actionServiceDescriptors.add(serviceDescriptors[i]);
            }
            ++i;
        }
        this.processServiceIndex = this.buildServices(definition, processServiceDescriptors);
        this.sessionServiceIndex = this.buildServices(definition, sessionServiceDescriptors);
        this.executionServiceIndex = this.buildServices(definition, executionServiceDescriptors);
        this.actionServiceIndex = this.buildServices(definition, actionServiceDescriptors);
        this.executableIndex = this.buildExecutables(definition, actionDescriptors, observerDescriptors);
        this.entryPointIndex = this.linkExecutables(definition);
        this.registry = registry;
    }

    public Collection createConfigurations(Element data) {
        String xmlIdentifier = RuntimeUtils.getXMLIdentifier(data);
        List descriptors = (List)this.configurationIndex.get(xmlIdentifier);
        if (descriptors == null || descriptors.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Configuration> results = new ArrayList<Configuration>(descriptors.size());
        Iterator i = descriptors.iterator();
        while (i.hasNext()) {
            results.add(new Configuration(this, (ConfigurationDescriptor)i.next(), data));
        }
        return results;
    }

    public void solidifyConfigurations(IContext serviceRegistry) {
        for (List list : this.processServiceIndex.values()) {
            for (Configurable configurable : list) {
                configurable.solidifyConfigurations(serviceRegistry);
            }
        }
        for (List list : this.sessionServiceIndex.values()) {
            for (Configurable configurable : list) {
                configurable.solidifyConfigurations(serviceRegistry);
            }
        }
        for (List list : this.executionServiceIndex.values()) {
            for (Configurable configurable : list) {
                configurable.solidifyConfigurations(serviceRegistry);
            }
        }
        for (List list : this.actionServiceIndex.values()) {
            for (Configurable configurable : list) {
                configurable.solidifyConfigurations(serviceRegistry);
            }
        }
        for (Configurable configurable : this.executableIndex.values()) {
            configurable.solidifyConfigurations(serviceRegistry);
        }
    }

    public Collection getProcessServices(String identifier) {
        return (List)this.processServiceIndex.get(identifier);
    }

    public Collection getSessionServices(String identifier) {
        return (List)this.sessionServiceIndex.get(identifier);
    }

    public Collection getExecutionServices(String identifier) {
        return (List)this.executionServiceIndex.get(identifier);
    }

    public Collection getActionServices(String identifier) {
        return (List)this.actionServiceIndex.get(identifier);
    }

    public Executable getExecutable(String instanceID) {
        return (Executable)this.executableIndex.get(instanceID);
    }

    public Executable getEntryPoint(String entryName) {
        return this.entryPointIndex.get(entryName);
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    private Map indexConfigurations(ConfigurationDescriptor[] configurationDescriptors) {
        HashMap<String, LinkedList<ConfigurationDescriptor>> configurationDescriptorIndex = new HashMap<String, LinkedList<ConfigurationDescriptor>>(configurationDescriptors.length);
        int i = 0;
        while (i < configurationDescriptors.length) {
            String string = RuntimeUtils.getQualifiedIdentifier(configurationDescriptors[i].getXmlTag(), configurationDescriptors[i].getXmlNamespace());
            LinkedList<ConfigurationDescriptor> list = (LinkedList<ConfigurationDescriptor>)configurationDescriptorIndex.get(string);
            if (list == null) {
                list = new LinkedList<ConfigurationDescriptor>();
                configurationDescriptorIndex.put(string, list);
            }
            list.addLast(configurationDescriptors[i]);
            ++i;
        }
        for (Map.Entry entry : configurationDescriptorIndex.entrySet()) {
            entry.setValue(Collections.unmodifiableList(new ArrayList((LinkedList)entry.getValue())));
        }
        return Collections.unmodifiableMap(new HashMap(configurationDescriptorIndex));
    }

    private Map buildServices(IProcessDefinition definition, List serviceDescriptors) {
        HashMap<String, LinkedList<Service>> serviceIndex = new HashMap<String, LinkedList<Service>>(serviceDescriptors.size());
        for (ServiceDescriptor descriptor : serviceDescriptors) {
            Service service = new Service(this, definition.getServiceConfiguration(descriptor.getId()), descriptor);
            for (String identifier : service.getIdentifiers()) {
                LinkedList<Service> list = (LinkedList<Service>)serviceIndex.get(identifier);
                if (list == null) {
                    list = new LinkedList<Service>();
                    serviceIndex.put(identifier, list);
                }
                list.addLast(service);
            }
        }
        return Collections.unmodifiableMap(new HashMap(serviceIndex));
    }

    private Map buildExecutables(IProcessDefinition definition, ActionDescriptor[] actionDescriptors, ObserverDescriptor[] observerDescriptors) {
        HashMap<String, ActionDescriptor> actionIndex = new HashMap<String, ActionDescriptor>();
        int i = 0;
        while (i < actionDescriptors.length) {
            actionIndex.put(actionDescriptors[i].getId(), actionDescriptors[i]);
            ++i;
        }
        HashMap<String, ObserverDescriptor> observerIndex = new HashMap<String, ObserverDescriptor>();
        int i2 = 0;
        while (i2 < observerDescriptors.length) {
            observerIndex.put(observerDescriptors[i2].getId(), observerDescriptors[i2]);
            ++i2;
        }
        HashMap<String, Executable> executableIndex = new HashMap<String, Executable>();
        String[] actionIDs = definition.getActionInstanceIDs();
        int i3 = 0;
        while (i3 < actionIDs.length) {
            String actionID = actionIDs[i3];
            Action action = new Action(this, definition.getActionName(actionID), definition.getActionConfiguration(actionID), actionID, (ActionDescriptor)actionIndex.get(definition.getActionDescriptorID(actionID)));
            executableIndex.put(actionID, action);
            String[] observerIDs = definition.getBeforeObserverInstanceIDs(actionID);
            int j = 0;
            while (j < observerIDs.length) {
                String observerID = observerIDs[j];
                Observer observer = new Observer(this, definition.getObserverConfiguration(observerID), observerID, (ObserverDescriptor)observerIndex.get(definition.getObserverDescriptorID(observerID)), action);
                executableIndex.put(observerID, observer);
                ++j;
            }
            String[] resultIDs = definition.getActionResultIDs(actionID);
            int j2 = 0;
            while (j2 < resultIDs.length) {
                observerIDs = definition.getAfterObserverInstanceIDs(actionID, resultIDs[j2]);
                int k = 0;
                while (k < observerIDs.length) {
                    String observerID = observerIDs[k];
                    Observer observer = new Observer(this, definition.getObserverConfiguration(observerID), observerID, (ObserverDescriptor)observerIndex.get(definition.getObserverDescriptorID(observerID)), action);
                    executableIndex.put(observerID, observer);
                    ++k;
                }
                ++j2;
            }
            ++i3;
        }
        return Collections.unmodifiableMap(new HashMap(executableIndex));
    }

    private Map<String, Executable> linkExecutables(IProcessDefinition definition) {
        HashMap<String, Executable> index = new HashMap<String, Executable>();
        HashMap<String, Executable> targetsByActionID = new HashMap<String, Executable>();
        String[] actionIDs = definition.getActionInstanceIDs();
        int i = 0;
        while (i < actionIDs.length) {
            String actionID = actionIDs[i];
            Action action = (Action)this.getExecutable(actionID);
            String[] observerIDs = definition.getBeforeObserverInstanceIDs(actionID);
            Observer previous = null;
            int j = 0;
            while (j < observerIDs.length) {
                String observerID = observerIDs[j];
                Observer observer = (Observer)this.getExecutable(observerID);
                if (previous == null) {
                    targetsByActionID.put(actionID, observer);
                } else {
                    previous.configure(observer);
                }
                previous = observer;
                ++j;
            }
            if (previous == null) {
                targetsByActionID.put(actionID, action);
            } else {
                previous.configure(action);
            }
            ++i;
        }
        i = 0;
        while (i < actionIDs.length) {
            Action action = (Action)this.getExecutable(actionIDs[i]);
            String[] resultIDs = definition.getActionResultIDs(actionIDs[i]);
            int j = 0;
            while (j < resultIDs.length) {
                Executable result = null;
                String[] observerIDs = definition.getAfterObserverInstanceIDs(actionIDs[i], resultIDs[j]);
                Observer previous = null;
                int k = 0;
                while (k < observerIDs.length) {
                    Observer observer = (Observer)this.getExecutable(observerIDs[k]);
                    if (previous == null) {
                        result = observer;
                    } else {
                        previous.configure(observer);
                    }
                    previous = observer;
                    ++k;
                }
                Executable target = (Executable)targetsByActionID.get(definition.getActionResultTargetInstanceID(actionIDs[i], resultIDs[j]));
                if (previous == null) {
                    result = target;
                } else {
                    previous.configure(target);
                }
                action.configure(resultIDs[j], result);
                ++j;
            }
            ++i;
        }
        String[] startActionIds = definition.getStartActionInstanceIDs();
        index.put("Default", (Executable)targetsByActionID.get(startActionIds[0]));
        String[] stringArray = startActionIds;
        int n = startActionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String startActionId = stringArray[n2];
            index.put(definition.getActionName(startActionId), (Executable)targetsByActionID.get(startActionId));
            ++n2;
        }
        return index;
    }
}

