/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import org.w3c.dom.Element;

public final class RuntimeUtils {
    public static String getQualifiedIdentifier(String identifier, String qualifier) throws NullPointerException {
        if (qualifier == null) {
            throw new NullPointerException("qualifier");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        return new StringBuffer(identifier.length() + 1 + qualifier.length()).append(identifier).append(':').append(qualifier).toString();
    }

    public static String getXMLIdentifier(Element element) throws NullPointerException {
        if (element == null) {
            throw new NullPointerException("element");
        }
        return RuntimeUtils.getQualifiedIdentifier(element.getLocalName(), element.getNamespaceURI());
    }

    public static void listTypeHierarchy(Class type, Set types) throws NullPointerException {
        if (type == null) {
            return;
        }
        if (types == null) {
            throw new NullPointerException("types");
        }
        RuntimeUtils.listTypeHierarchy(type.getSuperclass(), types);
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                RuntimeUtils.listTypeHierarchy(interfaces[i], types);
                ++i;
            }
        }
        types.add(type);
    }

    public static Object createInstance(Class type) throws IllegalStateException, NullPointerException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static Object createInstance(Constructor constructor, Object[] arguments) throws IllegalStateException, NullPointerException {
        if (constructor == null) {
            throw new NullPointerException("constructor");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments");
        }
        Class<?>[] types = constructor.getParameterTypes();
        if (types.length != arguments.length) {
            throw new IllegalArgumentException("arguments");
        }
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] == null) {
                throw new NullPointerException("arguments[" + i + "]");
            }
            ++i;
        }
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static void setProperty(Object instance, Method mutator, Object value) throws IllegalStateException, NullPointerException {
        if (instance == null) {
            throw new NullPointerException("instance");
        }
        if (mutator == null) {
            throw new NullPointerException("mutator");
        }
        if (mutator.getParameterTypes().length != 1) {
            throw new IllegalArgumentException("mutator");
        }
        try {
            mutator.invoke(instance, value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

