/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.engine.support;

import java.util.Date;
import java.util.Dictionary;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.engine.support.AbstractActionContext;

public abstract class ActionContextWrapper
implements IActionContext {
    protected ActionContextWrapper() {
    }

    protected boolean isReservedIdentifier(String identifier) {
        return AbstractActionContext.RESERVED_SERVICE_IDENTIFIERS.contains(identifier);
    }

    protected abstract IActionContext getActionContext();

    public boolean isSeverityEnabled(int severity) {
        return this.getActionContext().isSeverityEnabled(severity);
    }

    public boolean isReportingEnabled() {
        return this.getActionContext().isReportingEnabled();
    }

    public void report(int severity, String message) {
        this.getActionContext().report(severity, message);
    }

    public void report(int severity, String message, Dictionary properties) {
        this.getActionContext().report(severity, message, properties);
    }

    public void report(int severity, String[] categories, String message) {
        this.getActionContext().report(severity, categories, message);
    }

    public void report(int severity, String[] categories, String message, Dictionary properties) {
        this.getActionContext().report(severity, categories, message, properties);
    }

    public void log(int severity, String message) {
        this.getActionContext().log(severity, message);
    }

    public void log(int severity, String message, Dictionary properties) {
        this.getActionContext().log(severity, message, properties);
    }

    public void log(int severity, String[] categories, String message) {
        this.getActionContext().log(severity, categories, message);
    }

    public void log(int severity, String[] categories, String message, Dictionary properties) {
        this.getActionContext().log(severity, categories, message, properties);
    }

    public boolean isErrorEnabled() {
        return this.getActionContext().isErrorEnabled();
    }

    public void error(String message) {
        this.getActionContext().error(message);
    }

    public void error(String message, Dictionary properties) {
        this.getActionContext().error(message, properties);
    }

    public void error(String[] categories, String message) {
        this.getActionContext().error(categories, message);
    }

    public void error(String[] categories, String message, Dictionary properties) {
        this.getActionContext().error(categories, message, properties);
    }

    public boolean isWarnEnabled() {
        return this.getActionContext().isWarnEnabled();
    }

    public void warn(String message) {
        this.getActionContext().warn(message);
    }

    public void warn(String message, Dictionary properties) {
        this.getActionContext().warn(message, properties);
    }

    public void warn(String[] categories, String message) {
        this.getActionContext().warn(categories, message);
    }

    public void warn(String[] categories, String message, Dictionary properties) {
        this.getActionContext().warn(categories, message, properties);
    }

    public boolean isInfoEnabled() {
        return this.getActionContext().isInfoEnabled();
    }

    public void info(String message) {
        this.getActionContext().info(message);
    }

    public void info(String message, Dictionary properties) {
        this.getActionContext().info(message, properties);
    }

    public void info(String[] categories, String message) {
        this.getActionContext().info(categories, message);
    }

    public void info(String[] categories, String message, Dictionary properties) {
        this.getActionContext().info(categories, message, properties);
    }

    public boolean isDebugEnabled() {
        return this.getActionContext().isDebugEnabled();
    }

    public void debug(String message) {
        this.getActionContext().debug(message);
    }

    public void debug(String message, Dictionary properties) {
        this.getActionContext().debug(message, properties);
    }

    public void debug(String[] categories, String message) {
        this.getActionContext().debug(categories, message);
    }

    public void debug(String[] categories, String message, Dictionary properties) {
        this.getActionContext().debug(categories, message, properties);
    }

    public Object lookup(String identifier) throws NullPointerException {
        if (this.isReservedIdentifier(identifier)) {
            return this;
        }
        return this.getActionContext().lookup(identifier);
    }

    public Object[] lookupAll(String identifier) throws NullPointerException {
        if (this.isReservedIdentifier(identifier)) {
            return new Object[]{this};
        }
        return this.getActionContext().lookupAll(identifier);
    }

    public String getProcessID() {
        return this.getActionContext().getProcessID();
    }

    public Object getProperty(String propertyName) throws NullPointerException {
        return this.getActionContext().getProperty(propertyName);
    }

    public Class loadClass(String className) throws ClassNotFoundException, NullPointerException {
        return this.getActionContext().loadClass(className);
    }

    public String getSessionID() {
        return this.getActionContext().getSessionID();
    }

    public Date getSessionStartTime() {
        return this.getActionContext().getSessionStartTime();
    }

    public String[] getAttributeNames() {
        return this.getActionContext().getAttributeNames();
    }

    public Object getAttribute(String attributeName) throws NullPointerException {
        return this.getActionContext().getAttribute(attributeName);
    }

    public void setAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        this.getActionContext().setAttribute(attributeName, attributeValue);
    }

    public void clearAttribute(String attributeName) throws NullPointerException {
        this.getActionContext().clearAttribute(attributeName);
    }

    public String getExecutionID() {
        return this.getActionContext().getExecutionID();
    }

    public String[] getParameterNames() {
        return this.getActionContext().getParameterNames();
    }

    public String getParameter(String parameterName) throws NullPointerException {
        return this.getActionContext().getParameter(parameterName);
    }

    public String[] getParameters(String parameterName) throws NullPointerException {
        return this.getActionContext().getParameters(parameterName);
    }

    public void setParameter(String parameterName, String value) throws NullPointerException {
        this.getActionContext().setParameter(parameterName, value);
    }

    public void setParameters(String parameterName, String[] values) throws NullPointerException {
        this.getActionContext().setParameters(parameterName, values);
    }

    public void clearParameter(String parameterName) throws NullPointerException {
        this.getActionContext().clearParameter(parameterName);
    }

    public String getActionID() {
        return this.getActionContext().getActionID();
    }

    public String getActionName() {
        return this.getActionContext().getActionName();
    }

    public int getActionState() {
        return this.getActionContext().getActionState();
    }

    public IActionResult createResult(String resultName) {
        return this.getActionContext().createResult(resultName);
    }

    public IActionResult createResult(String resultName, Throwable failureCause) {
        return this.getActionContext().createResult(resultName, failureCause);
    }

    public String[] getRootAttributeNames() {
        return this.getActionContext().getRootAttributeNames();
    }

    public Object getRootAttribute(String attributeName) throws NullPointerException {
        return this.getActionContext().getRootAttribute(attributeName);
    }

    public void setRootAttribute(String attributeName, Object attributeValue) throws NullPointerException {
        this.getActionContext().setRootAttribute(attributeName, attributeValue);
    }

    public void clearRootAttribute(String attributeName) throws NullPointerException {
        this.getActionContext().clearRootAttribute(attributeName);
    }
}

