/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.actions.ExitAction;
import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.eclipse.vtp.framework.common.configurations.ExitConfiguration;
import org.eclipse.vtp.framework.common.controller.IController;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.eclipse.vtp.framework.interactions.core.conversation.IFinal;

public class FinalAction
extends ExitAction {
    private final IConversation conversation;
    private final IVariableRegistry variableRegistry;
    protected final AssignmentConfiguration[] configurations;

    public FinalAction(IActionContext context, IController controller, ExitConfiguration configuration, IConversation conversation, IVariableRegistry variableRegistry, AssignmentConfiguration[] configurations) {
        super(context, controller, configuration, configurations);
        this.conversation = conversation;
        this.variableRegistry = variableRegistry;
        this.configurations = configurations;
    }

    public IActionResult execute() {
        if ("true".equals(this.context.getAttribute("subdialog"))) {
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "final");
                this.context.report(3, "Ending subdialog execution.", props);
            }
            IFinal f = this.conversation.createFinal();
            int i = 0;
            while (i < this.configurations.length) {
                f.setVariableValue(this.configurations[i].getName(), this.variableRegistry.getVariable(this.configurations[i].getName()).toString());
                ++i;
            }
            f.setVariableValue("DialogReturnValue", this.configuration.getValue());
            f.enqueue();
            return this.context.createResult("abort");
        }
        if ("true".equals(this.context.getAttribute("fragment"))) {
            return super.execute();
        }
        this.conversation.createEndMessage().enqueue();
        return this.context.createResult("abort");
    }
}

