/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandRegistry;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDataType;
import org.eclipse.vtp.framework.common.IDataTypeRegistry;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.common.actions.AssignmentAction;
import org.eclipse.vtp.framework.common.configurations.AssignmentConfiguration;
import org.eclipse.vtp.framework.common.configurations.InitialConfiguration;
import org.eclipse.vtp.framework.common.support.CustomDataField;
import org.eclipse.vtp.framework.common.support.CustomDataType;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.ILanguageRegistry;
import org.eclipse.vtp.framework.interactions.core.ILanguageSelection;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.eclipse.vtp.framework.interactions.core.platforms.IPlatformSelector;
import org.eclipse.vtp.framework.interactions.core.support.AbstractPlatform;
import org.eclipse.vtp.framework.util.Guid;

public class InitialAction
extends AssignmentAction {
    private static final Set INITAL_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Boolean", "Date", "Decimal", "Number", "String")));
    private final IConversation conversation;
    private final IBrandSelection brand;
    private final IDataTypeRegistry dataTypeRegistry;
    private final IPlatformSelector platformSelector;
    private final InitialConfiguration initialConfig;
    private final IBrandRegistry brandRegistry;
    private final ILanguageSelection languageSelection;
    private final ILanguageRegistry languageRegistry;

    public InitialAction(IActionContext context, IVariableRegistry variableRegistry, IDataTypeRegistry dataTypeRegistry, AssignmentConfiguration[] assignCongigs, IConversation conversation, IBrandSelection brand, IPlatformSelector platformSelector, InitialConfiguration initialConfig, IBrandRegistry brandRegistry, ILanguageSelection languageSelection, ILanguageRegistry languageRegistry) {
        super(context, variableRegistry, assignCongigs);
        this.conversation = conversation;
        this.brand = brand;
        this.dataTypeRegistry = dataTypeRegistry;
        this.platformSelector = platformSelector;
        this.initialConfig = initialConfig;
        this.brandRegistry = brandRegistry;
        this.languageSelection = languageSelection;
        this.languageRegistry = languageRegistry;
    }

    public IActionResult execute() {
        String result = this.context.getParameter(this.context.getActionID());
        if ("success.filled".equals(result)) {
            IBrand b;
            String dnisvalue;
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "initial.after");
                this.context.report(3, "Processing initial variables.", props);
            }
            IDataObject platform = this.variableRegistry.createVariable("Platform");
            String anivalue = this.context.getParameter("PLATFORM_ANI");
            if (anivalue != null) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props2 = new Hashtable<String, String>();
                    ((Dictionary)props2).put("event", "assignment");
                    ((Dictionary)props2).put("event.key", "Platform.ANI");
                    ((Dictionary)props2).put("event.value", String.valueOf(anivalue));
                    this.context.report(3, "Assigned variable \"Platform.ANI\" to \"" + anivalue + "\"", props2);
                }
                ((IStringObject)platform.getField("ANI")).setValue((Object)anivalue);
                ((IStringObject)platform.getField("PLATFORM_ANI")).setValue((Object)anivalue);
            }
            if ((dnisvalue = this.context.getParameter("PLATFORM_DNIS")) != null) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props2 = new Hashtable<String, String>();
                    ((Dictionary)props2).put("event", "assignment");
                    ((Dictionary)props2).put("event.key", "Platform.DNIS");
                    ((Dictionary)props2).put("event.value", String.valueOf(dnisvalue));
                    this.context.report(3, "Assigned variable \"Platform.DNIS\" to \"" + dnisvalue + "\"", props2);
                }
                ((IStringObject)platform.getField("DNIS")).setValue((Object)dnisvalue);
                ((IStringObject)platform.getField("PLATFORM_DNIS")).setValue((Object)dnisvalue);
            }
            if ((b = this.brand.getSelectedBrand()) != null) {
                ((IStringObject)platform.getField("Brand")).setValue((Object)b.getName());
            } else {
                b = this.brandRegistry.getBrandById(this.initialConfig.getDefaultBrandId());
                if (b != null) {
                    ((IStringObject)platform.getField("Brand")).setValue((Object)b.getName());
                } else {
                    ((IStringObject)platform.getField("Brand")).setValue((Object)this.brandRegistry.getDefaultBrand().getName());
                }
            }
            this.languageSelection.setDefaultLanguage(this.initialConfig.getDefaultLanguageName());
            this.variableRegistry.setVariable("Platform", platform);
            HashMap<String, String> values = new HashMap<String, String>();
            int i = 0;
            while (i < this.configurations.length) {
                String value = this.context.getParameter(this.configurations[i].getName());
                if (value != null && value.length() > 0) {
                    values.put(this.configurations[i].getName(), value);
                }
                ++i;
            }
            AbstractPlatform abstractPlatform = (AbstractPlatform)this.platformSelector.getSelectedPlatform();
            List<String> incomingParametersNames = abstractPlatform.getPlatformVariableNames();
            if (incomingParametersNames.size() > 0) {
                int i2 = 0;
                while (i2 < incomingParametersNames.size()) {
                    incomingParametersNames.set(i2, incomingParametersNames.get(i2).replaceAll(Pattern.quote("."), "_"));
                    incomingParametersNames.set(i2, incomingParametersNames.get(i2).replaceAll("-", "_"));
                    ++i2;
                }
                CustomDataField[] platformFields = new CustomDataField[incomingParametersNames.size()];
                int i3 = 0;
                while (i3 < incomingParametersNames.size()) {
                    platformFields[i3] = new CustomDataField(incomingParametersNames.get(i3), this.dataTypeRegistry.getDataType("String"), "");
                    ++i3;
                }
                CustomDataType cdt = new CustomDataType(Guid.createGUID(), incomingParametersNames.get(0), platformFields);
                IDataObject initialParameters = this.variableRegistry.createVariable((IDataType)cdt);
                int i4 = 0;
                while (i4 < incomingParametersNames.size()) {
                    String parameter = this.context.getParameter(incomingParametersNames.get(i4));
                    IStringObject field = (IStringObject)initialParameters.getField(incomingParametersNames.get(i4));
                    if (field != null) {
                        field.setValue((Object)(parameter == null ? "" : parameter));
                    }
                    ++i4;
                }
                this.variableRegistry.setVariable("PlatformVariables", initialParameters);
            }
            return this.execute(values, false);
        }
        if ("error.disconnect.hangup".equals(result)) {
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "error.disconnect.hangup");
                this.context.report(3, "Got disconnect during interaction.", props);
            }
            return this.context.createResult("error.disconnect.hangup");
        }
        if (result != null) {
            return this.context.createResult(result);
        }
        try {
            String[] incomingParametersNames = this.context.getParameterNames();
            int i = 0;
            while (i < incomingParametersNames.length) {
                incomingParametersNames[i] = incomingParametersNames[i].replaceAll(Pattern.quote("."), "_");
                incomingParametersNames[i] = incomingParametersNames[i].replaceAll("-", "_");
                ++i;
            }
            CustomDataField[] fields = new CustomDataField[incomingParametersNames.length];
            int i5 = 0;
            while (i5 < incomingParametersNames.length) {
                fields[i5] = new CustomDataField(incomingParametersNames[i5], this.dataTypeRegistry.getDataType("String"), "");
                ++i5;
            }
            if (fields.length < 1) {
                fields = new CustomDataField[]{new CustomDataField("empty", this.dataTypeRegistry.getDataType("String"), "")};
            }
            CustomDataType cdt = new CustomDataType(Guid.createGUID(), incomingParametersNames.length > 1 ? incomingParametersNames[0] : "empty", fields);
            IDataObject initialParameters = this.variableRegistry.createVariable((IDataType)cdt);
            int i6 = 0;
            while (i6 < incomingParametersNames.length) {
                String parameter = this.context.getParameter(incomingParametersNames[i6]);
                IStringObject field = (IStringObject)initialParameters.getField(incomingParametersNames[i6]);
                if (field != null) {
                    field.setValue((Object)(parameter == null ? "" : parameter));
                }
                ++i6;
            }
            this.variableRegistry.setVariable("InitialParameters", initialParameters);
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "initial.before");
                this.context.report(3, "Requesting initial variables.", props);
            }
            LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
            if ("true".equals(this.context.getAttribute("subdialog"))) {
                int i7 = 0;
                while (i7 < this.configurations.length) {
                    if (INITAL_TYPES.contains(this.configurations[i7].getType())) {
                        vars.put(this.configurations[i7].getName(), this.configurations[i7].getValue());
                    }
                    ++i7;
                }
            }
            this.conversation.createInitial(this.context.getActionID(), vars).enqueue();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return this.context.createResult("repeat");
    }
}

