/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.ILastResult;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.InputRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InputRequestAction
implements IAction {
    private static final BigDecimal BD_100 = new BigDecimal(100);
    private final IActionContext context;
    private final IVariableRegistry variableRegistry;
    private final IConversation conversation;
    private final ILastResult lastResult;
    private final InputRequestConfiguration configuration;

    public InputRequestAction(IActionContext context, IVariableRegistry variableRegistry, IConversation conversation, ILastResult lastResult, InputRequestConfiguration configuration) {
        this.context = context;
        this.variableRegistry = variableRegistry;
        this.conversation = conversation;
        this.lastResult = lastResult;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        try {
            if (this.context.isDebugEnabled()) {
                this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            }
            String result = this.context.getParameter(this.context.getActionID());
            this.context.clearParameter(this.context.getActionID());
            if ("success.filled".equals(result)) {
                String value = this.context.getParameter(this.configuration.getDataName());
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "input.request.filled");
                    ((Dictionary)props).put("input.result", this.configuration.isSecured() ? "**Secured**" : String.valueOf(value));
                    this.context.report(3, "Got requested input \"" + (this.configuration.isSecured() ? "**Secured**" : String.valueOf(value)) + "\"", props);
                }
                this.lastResult.clear();
                String lastResultXML = this.context.getParameter("lastresult");
                if (lastResultXML != null && !lastResultXML.equals("")) {
                    Document lastResultDocument = null;
                    try {
                        lastResultDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(lastResultXML.getBytes()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    NodeList markList = lastResultDocument.getDocumentElement().getElementsByTagName("mark");
                    if (markList.getLength() > 0) {
                        Element markElement = (Element)markList.item(0);
                        this.lastResult.setMarkName(markElement.getAttribute("name"));
                        this.lastResult.setMarkTime(markElement.getAttribute("offset"));
                    }
                    NodeList nl = lastResultDocument.getDocumentElement().getElementsByTagName("result");
                    int i = 0;
                    while (i < nl.getLength()) {
                        Element resultElement = (Element)nl.item(i);
                        Element confidenceElement = (Element)resultElement.getElementsByTagName("confidence").item(0);
                        Element utteranceElement = (Element)resultElement.getElementsByTagName("utterance").item(0);
                        Element inputModeElement = (Element)resultElement.getElementsByTagName("inputmode").item(0);
                        Element interpretationElement = (Element)resultElement.getElementsByTagName("interpretation").item(0);
                        this.lastResult.addResult(new BigDecimal(confidenceElement.getTextContent()).multiply(BD_100).intValue(), utteranceElement.getTextContent(), inputModeElement.getTextContent(), interpretationElement.getTextContent());
                        ++i;
                    }
                }
                IStringObject variable = (IStringObject)this.variableRegistry.createVariable("String");
                variable.setValue((Object)value);
                this.variableRegistry.setVariable(this.configuration.getDataName(), (IDataObject)variable);
                return this.context.createResult("default");
            }
            if ("error.input.noinput".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "input.request.noinput");
                    this.context.report(3, "Got no input for requested input.", props);
                }
                return this.context.createResult("error.input.noinput");
            }
            if ("error.disconnect.hangup".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "error.disconnect.hangup");
                    this.context.report(3, "Got disconnect during interaction.", props);
                }
                return this.context.createResult("error.disconnect.hangup");
            }
            if ("error.input.nomatch".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "input.request.nomatch");
                    this.context.report(3, "Got no match for requested input.", props);
                }
                String lastResultXML = this.context.getParameter("lastresult");
                Document lastResultDocument = null;
                try {
                    lastResultDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(lastResultXML.getBytes()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.lastResult.clear();
                NodeList markList = lastResultDocument.getDocumentElement().getElementsByTagName("mark");
                if (markList.getLength() > 0) {
                    Element markElement = (Element)markList.item(0);
                    this.lastResult.setMarkName(markElement.getAttribute("name"));
                    this.lastResult.setMarkTime(markElement.getAttribute("offset"));
                }
                NodeList nl = lastResultDocument.getDocumentElement().getElementsByTagName("result");
                int i = 0;
                while (i < nl.getLength()) {
                    Element resultElement = (Element)nl.item(i);
                    Element confidenceElement = (Element)resultElement.getElementsByTagName("confidence").item(0);
                    Element utteranceElement = (Element)resultElement.getElementsByTagName("utterance").item(0);
                    Element inputModeElement = (Element)resultElement.getElementsByTagName("inputmode").item(0);
                    Element interpretationElement = (Element)resultElement.getElementsByTagName("interpretation").item(0);
                    int confidenceValue = 0;
                    try {
                        BigDecimal confidenceBigDecimal = new BigDecimal(confidenceElement.getTextContent());
                        confidenceValue = confidenceBigDecimal.multiply(BD_100).intValue();
                    }
                    catch (Exception ex) {
                        this.context.info("Invalid confidence value: " + confidenceElement.getTextContent());
                        this.context.info("Defaulting confidence to 0.");
                    }
                    this.lastResult.addResult(confidenceValue, utteranceElement.getTextContent(), inputModeElement.getTextContent(), interpretationElement.getTextContent());
                    ++i;
                }
                return this.context.createResult("error.input.nomatch");
            }
            if (result != null) {
                return this.context.createResult(result);
            }
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "input.request.before");
                this.context.report(3, "Requesting input \"" + this.configuration.getDataName() + "\".", props);
            }
            this.conversation.createInputRequest(this.configuration, this.context.getActionID()).enqueue();
            return this.context.createResult("repeat");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.input.request", (Throwable)e);
        }
    }
}

