/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.vtp.framework.common.IBooleanObject;
import org.eclipse.vtp.framework.common.IBrand;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IDateObject;
import org.eclipse.vtp.framework.common.IDecimalObject;
import org.eclipse.vtp.framework.common.INumberObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.MetaDataItemConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.eclipse.vtp.framework.interactions.core.platforms.IPlatformSelector;
import org.eclipse.vtp.framework.interactions.core.support.AbstractPlatform;

public class MetaDataRequestAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final MetaDataConfiguration configuration;
    private final IVariableRegistry variables;
    private final IBrandSelection brandSelection;
    private final IPlatformSelector platformSelector;

    public MetaDataRequestAction(IActionContext context, IConversation conversation, MetaDataConfiguration configuration, IVariableRegistry variables, IBrandSelection brandSelection, IPlatformSelector platformSelector) {
        this.context = context;
        this.conversation = conversation;
        this.configuration = configuration;
        this.variables = variables;
        this.brandSelection = brandSelection;
        this.platformSelector = platformSelector;
    }

    public IActionResult execute() {
        try {
            if (this.context.isDebugEnabled()) {
                this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            }
            String value = this.context.getParameter("ad_" + this.context.getActionID());
            this.context.clearParameter("ad_" + this.context.getActionID());
            if ("success.filled".equals(value)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "metadata.request.filled");
                    this.context.report(3, "Received meta-data.", props);
                }
                IBrand brand = this.brandSelection.getSelectedBrand();
                MetaDataItemConfiguration[] items = null;
                while (brand != null && items == null) {
                    items = this.configuration.getItem(String.valueOf(brand.getName()));
                    brand = brand.getParentBrand();
                }
                AbstractPlatform platform = (AbstractPlatform)this.platformSelector.getSelectedPlatform();
                Map dataMap = platform.processMetaDataResponse(this.configuration, this.context);
                if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        IDataObject object = this.variables.getVariable(items[i].getValue());
                        if (object == null) {
                            object = this.variables.createVariable("String");
                            this.variables.setVariable(items[i].getValue(), object);
                        }
                        IDataObject toSet = object;
                        String primaryField = object.getType().getPrimaryFieldName();
                        if (primaryField != null) {
                            toSet = object.getField(primaryField);
                        }
                        if (toSet instanceof IBooleanObject) {
                            ((IBooleanObject)toSet).setValue(dataMap.get(items[i].getName()));
                        } else if (toSet instanceof IDateObject) {
                            ((IDateObject)toSet).setValue(dataMap.get(items[i].getName()));
                        } else if (toSet instanceof IDecimalObject) {
                            ((IDecimalObject)toSet).setValue(dataMap.get(items[i].getName()));
                        } else if (toSet instanceof INumberObject) {
                            ((INumberObject)toSet).setValue(dataMap.get(items[i].getName()));
                        } else if (toSet instanceof IStringObject) {
                            ((IStringObject)toSet).setValue(dataMap.get(items[i].getName()));
                        }
                        ++i;
                    }
                }
                return this.context.createResult("default");
            }
            if ("error.disconnect.hangup".equals(value)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "error.disconnect.hangup");
                    this.context.report(3, "Got disconnect during interaction.", props);
                }
                return this.context.createResult("error.disconnect.hangup");
            }
            if (value != null) {
                return this.context.createResult(value);
            }
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "metadata.request.before");
                this.context.report(3, "Requesting meta-data.", props);
            }
            if (this.conversation.createMetaDataRequest(this.configuration, "ad_" + this.context.getActionID()).enqueue()) {
                return this.context.createResult("repeat");
            }
        }
        catch (Exception e) {
            return this.context.createResult("error.meta-data.request", (Throwable)e);
        }
        return this.context.createResult("error.meta-data.request");
    }
}

