/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.framework.common.ILastResult;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.SelectionRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SelectionRequestAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final SelectionRequestConfiguration configuration;
    private final ILastResult lastResult;

    public SelectionRequestAction(IActionContext context, IConversation conversation, SelectionRequestConfiguration configuration, ILastResult lastResult) {
        this.context = context;
        this.conversation = conversation;
        this.configuration = configuration;
        this.lastResult = lastResult;
    }

    public IActionResult execute() {
        try {
            if (this.context.isDebugEnabled()) {
                this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            }
            String result = this.context.getParameter(this.context.getActionID());
            this.context.clearParameter(this.context.getActionID());
            if ("success.filled".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "selection.request.filled");
                    ((Dictionary)props).put("event.key", "selection");
                    ((Dictionary)props).put("event.value", this.context.getParameter(this.configuration.getDataName()));
                    this.context.report(3, "Got requested selection \"" + this.context.getParameter(this.configuration.getDataName()) + "\"", props);
                }
                this.lastResult.clear();
                String lastResultXML = this.context.getParameter("lastresult");
                if (lastResultXML != null && !lastResultXML.equals("")) {
                    Document lastResultDocument = null;
                    try {
                        lastResultDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(lastResultXML.getBytes()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    NodeList nl = lastResultDocument.getDocumentElement().getElementsByTagName("result");
                    int i = 0;
                    while (i < nl.getLength()) {
                        Element resultElement = (Element)nl.item(i);
                        Element confidenceElement = (Element)resultElement.getElementsByTagName("confidence").item(0);
                        Element utteranceElement = (Element)resultElement.getElementsByTagName("utterance").item(0);
                        Element inputModeElement = (Element)resultElement.getElementsByTagName("inputmode").item(0);
                        Element interpretationElement = (Element)resultElement.getElementsByTagName("interpretation").item(0);
                        this.lastResult.addResult(new BigDecimal(confidenceElement.getTextContent()).multiply(new BigDecimal(100)).intValue(), utteranceElement.getTextContent(), inputModeElement.getTextContent(), interpretationElement.getTextContent());
                        ++i;
                    }
                }
                return this.context.createResult(this.context.getParameter(this.configuration.getDataName()));
            }
            if ("error.input.noinput".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "selection.request.noinput");
                    this.context.report(3, "Got no input for requested selection.", props);
                }
                return this.context.createResult("error.input.noinput");
            }
            if ("error.input.nomatch".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "selection.request.nomatch");
                    this.context.report(3, "Got no match for requested selection.", props);
                }
                this.lastResult.clear();
                String lastResultXML = this.context.getParameter("lastresult");
                if (lastResultXML != null && !lastResultXML.equals("")) {
                    Document lastResultDocument = null;
                    try {
                        lastResultDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(lastResultXML.getBytes()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    NodeList nl = lastResultDocument.getDocumentElement().getElementsByTagName("result");
                    int i = 0;
                    while (i < nl.getLength()) {
                        Element resultElement = (Element)nl.item(i);
                        Element confidenceElement = (Element)resultElement.getElementsByTagName("confidence").item(0);
                        Element utteranceElement = (Element)resultElement.getElementsByTagName("utterance").item(0);
                        Element inputModeElement = (Element)resultElement.getElementsByTagName("inputmode").item(0);
                        Element interpretationElement = (Element)resultElement.getElementsByTagName("interpretation").item(0);
                        this.lastResult.addResult(new BigDecimal(confidenceElement.getTextContent()).multiply(new BigDecimal(100)).intValue(), utteranceElement.getTextContent(), inputModeElement.getTextContent(), interpretationElement.getTextContent());
                        ++i;
                    }
                }
                return this.context.createResult("error.input.nomatch");
            }
            if ("error.disconnect.hangup".equals(result)) {
                if (this.context.isReportingEnabled()) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("event", "error.disconnect.hangup");
                    this.context.report(3, "Got disconnect during interaction.", props);
                }
                return this.context.createResult("error.disconnect.hangup");
            }
            if (result != null) {
                return this.context.createResult(result);
            }
            if (this.context.isReportingEnabled()) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "selection.request.before");
                this.context.report(3, "Requesting selection \"" + this.configuration.getDataName() + "\".", props);
            }
            this.conversation.createSelectionRequest(this.configuration, this.context.getActionID()).enqueue();
            return this.context.createResult("repeat");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.selection.request", (Throwable)e);
        }
    }
}

