/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;

public class InitialCommand
extends ConversationCommand {
    private String resultName = null;
    private String resultValue = null;
    private String hangupResultValue = null;
    private final Map variables = new LinkedHashMap();
    private final Map parameters = new HashMap();

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public String getResultValue() {
        return this.resultValue;
    }

    public void setResultValue(String resultValue) {
        this.resultValue = resultValue;
    }

    public String getHangupResultValue() {
        return this.hangupResultValue;
    }

    public void setHangupResultValue(String hangupResultValue) {
        this.hangupResultValue = hangupResultValue;
    }

    public String[] getVariableNames() {
        return this.variables.keySet().toArray(new String[this.variables.size()]);
    }

    public String getVariableValue(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.variables.get(name);
    }

    public boolean setVariable(String name, String value) {
        this.variables.put(name, value);
        return true;
    }

    public boolean removeVariable(String name) {
        return this.variables.remove(name) != null;
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        List list = (List)this.parameters.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public void setParameterValues(String name, String[] values) {
        if (name == null) {
            return;
        }
        if (values == null) {
            this.parameters.remove(name);
        } else {
            LinkedList<String> list = (LinkedList<String>)this.parameters.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.parameters.put(name, list);
            } else {
                list.clear();
            }
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    list.add(values[i]);
                }
                ++i;
            }
        }
    }

    @Override
    Object accept(IConversationCommandVisitor visitor) {
        return visitor.visitInitial(this);
    }

    public Object exportContents() {
        ArrayList<String> parameters = new ArrayList<String>(this.parameters.size() * 2);
        for (Map.Entry entry : this.parameters.entrySet()) {
            parameters.add((String)entry.getKey());
            parameters.add((String)entry.getValue());
        }
        ArrayList<String> variables = new ArrayList<String>(this.variables.size() * 2);
        for (Map.Entry entry : this.variables.entrySet()) {
            variables.add((String)entry.getKey());
            variables.add((String)entry.getValue());
        }
        return new Object[]{this.resultName, this.resultValue, this.hangupResultValue, variables.toArray(new String[variables.size()]), parameters.toArray(new String[parameters.size()])};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.resultName = (String)array[0];
        this.resultValue = (String)array[1];
        this.hangupResultValue = (String)array[2];
        this.variables.clear();
        String[] variables = (String[])array[3];
        int i = 0;
        while (i < variables.length) {
            this.variables.put(variables[i], variables[i + 1]);
            i += 2;
        }
        this.parameters.clear();
        String[] parameters = (String[])array[4];
        int i2 = 0;
        while (i2 < parameters.length) {
            this.parameters.put(parameters[i2], parameters[i2 + 1]);
            i2 += 2;
        }
    }
}

