/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;

public final class MetaDataMessageCommand
extends ConversationCommand {
    private String resultName = null;
    private String filledResultValue = null;
    private String hangupResultValue = null;
    private final Map metaData = new HashMap();
    private final Map parameters = new HashMap();
    private boolean ignoreErrors = false;

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public String getFilledResultValue() {
        return this.filledResultValue;
    }

    public void setFilledResultValue(String filledResultValue) {
        this.filledResultValue = filledResultValue;
    }

    public String getHangupResultValue() {
        return this.hangupResultValue;
    }

    public void setHangupResultValue(String hangupResultValue) {
        this.hangupResultValue = hangupResultValue;
    }

    public String[] getMetaDataNames() {
        return this.metaData.keySet().toArray(new String[this.metaData.size()]);
    }

    public String getMetaDataValue(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.metaData.get(name);
    }

    public void setMetaDataValue(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this.metaData.remove(name);
        } else {
            this.metaData.put(name, value);
        }
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        List list = (List)this.parameters.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public void setParameterValues(String name, String[] values) {
        if (name == null) {
            return;
        }
        if (values == null) {
            this.parameters.remove(name);
        } else {
            LinkedList<String> list = (LinkedList<String>)this.parameters.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.parameters.put(name, list);
            } else {
                list.clear();
            }
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    list.add(values[i]);
                }
                ++i;
            }
        }
    }

    @Override
    Object accept(IConversationCommandVisitor visitor) {
        return visitor.visitMetaDataMessage(this);
    }

    public Object exportContents() {
        ArrayList<String> metaData = new ArrayList<String>(this.metaData.size() * 2);
        for (Map.Entry entry : this.metaData.entrySet()) {
            metaData.add((String)entry.getKey());
            metaData.add((String)entry.getValue());
        }
        ArrayList<String> parameters = new ArrayList<String>(this.parameters.size() * 2);
        for (Map.Entry entry : this.parameters.entrySet()) {
            parameters.add((String)entry.getKey());
            parameters.add((String)entry.getValue());
        }
        return new Object[]{this.resultName, this.filledResultValue, Boolean.toString(this.ignoreErrors), metaData.toArray(new String[metaData.size()]), parameters.toArray(new String[parameters.size()])};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.resultName = (String)array[0];
        this.filledResultValue = (String)array[1];
        this.ignoreErrors = Boolean.parseBoolean((String)array[2]);
        this.metaData.clear();
        String[] metaData = (String[])array[3];
        int i = 0;
        while (i < metaData.length) {
            this.metaData.put(metaData[i], metaData[i + 1]);
            i += 2;
        }
        this.parameters.clear();
        String[] parameters = (String[])array[4];
        int i2 = 0;
        while (i2 < parameters.length) {
            this.parameters.put(parameters[i2], parameters[i2 + 1]);
            i2 += 2;
        }
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }
}

