/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;

public final class MetaDataRequestCommand
extends ConversationCommand {
    private String dataName = null;
    private String resultName = null;
    private String filledResultValue = null;
    private String hangupResultValue = null;
    private final Set metaData = new HashSet();
    private final Map parameters = new HashMap();

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String inputName) {
        this.dataName = inputName;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public String getFilledResultValue() {
        return this.filledResultValue;
    }

    public void setFilledResultValue(String filledResultValue) {
        this.filledResultValue = filledResultValue;
    }

    public String getHangupResultValue() {
        return this.hangupResultValue;
    }

    public void setHangupResultValue(String hangupResultValue) {
        this.hangupResultValue = hangupResultValue;
    }

    public String[] getMetaDataNames() {
        return this.metaData.toArray(new String[this.metaData.size()]);
    }

    public boolean addMetaDataName(String name) {
        if (name == null) {
            return false;
        }
        return this.metaData.add(name);
    }

    public boolean removeMetaDataName(String name) {
        if (name == null) {
            return false;
        }
        return this.metaData.remove(name);
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        List list = (List)this.parameters.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public void setParameterValues(String name, String[] values) {
        if (name == null) {
            return;
        }
        if (values == null) {
            this.parameters.remove(name);
        } else {
            LinkedList<String> list = (LinkedList<String>)this.parameters.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.parameters.put(name, list);
            } else {
                list.clear();
            }
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    list.add(values[i]);
                }
                ++i;
            }
        }
    }

    @Override
    Object accept(IConversationCommandVisitor visitor) {
        return visitor.visitMetaDataRequest(this);
    }

    public Object exportContents() {
        ArrayList<String> parameters = new ArrayList<String>(this.parameters.size() * 2);
        for (Map.Entry entry : this.parameters.entrySet()) {
            parameters.add((String)entry.getKey());
            parameters.add((String)entry.getValue());
        }
        return new Object[]{this.dataName, this.resultName, this.filledResultValue, this.metaData.toArray(new String[this.metaData.size()]), parameters.toArray(new String[parameters.size()])};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.dataName = (String)array[0];
        this.resultName = (String)array[1];
        this.filledResultValue = (String)array[2];
        this.metaData.clear();
        this.metaData.addAll(Arrays.asList((String[])array[3]));
        this.parameters.clear();
        String[] parameters = (String[])array[4];
        int i = 0;
        while (i < parameters.length) {
            this.parameters.put(parameters[i], parameters[i + 1]);
            i += 2;
        }
    }
}

