/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.interactions.core.commands.ConversationCommand;
import org.eclipse.vtp.framework.interactions.core.commands.IConversationCommandVisitor;
import org.eclipse.vtp.framework.interactions.core.commands.Input;
import org.eclipse.vtp.framework.interactions.core.commands.Output;

public final class SelectionRequestCommand
extends ConversationCommand {
    private String selectionName = null;
    private String resultName = null;
    private String filledResultValue = null;
    private String noInputResultValue = null;
    private String noMatchResultValue = null;
    private String hangupResultValue = null;
    private final Map properties = new HashMap();
    private final List<Output> output = new ArrayList<Output>();
    private final List options = new ArrayList();
    private final Map parameters = new HashMap();

    public String getSelectionName() {
        return this.selectionName;
    }

    public void setSelectionName(String inputName) {
        this.selectionName = inputName;
    }

    public String getResultName() {
        return this.resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    public String getFilledResultValue() {
        return this.filledResultValue;
    }

    public void setFilledResultValue(String filledResultValue) {
        this.filledResultValue = filledResultValue;
    }

    public String getNoInputResultValue() {
        return this.noInputResultValue;
    }

    public void setNoInputResultValue(String noInputResultValue) {
        this.noInputResultValue = noInputResultValue;
    }

    public String getNoMatchResultValue() {
        return this.noMatchResultValue;
    }

    public void setNoMatchResultValue(String noMatchResultValue) {
        this.noMatchResultValue = noMatchResultValue;
    }

    public String getHangupResultValue() {
        return this.hangupResultValue;
    }

    public void setHangupResultValue(String hangupResultValue) {
        this.hangupResultValue = hangupResultValue;
    }

    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public String getPropertyValue(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public void setPropertyValue(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public int getOutputCount() {
        return this.output.size();
    }

    public int getOutputType(int outputIndex) {
        if (outputIndex < 0 || outputIndex >= this.output.size()) {
            return 0;
        }
        if ("org.eclipse.vtp.output.File".equals(this.output.get(outputIndex).getType())) {
            return 1;
        }
        if ("org.eclipse.vtp.output.Text".equals(this.output.get(outputIndex).getType())) {
            return 2;
        }
        return 0;
    }

    public String getOutputValue(int outputIndex) {
        if (outputIndex < 0 || outputIndex >= this.output.size()) {
            return null;
        }
        return this.output.get(outputIndex).getProperty("value");
    }

    public void addOutput(Output o) {
        this.output.add(o);
    }

    public void insertOutput(int outputIndex, Output o) {
        if (outputIndex >= 0 && outputIndex <= this.output.size()) {
            this.output.add(outputIndex, o);
        }
    }

    public void setOutput(int outputIndex, Output o) {
        if (outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.set(outputIndex, o);
        }
    }

    public void removeOutput(int outputIndex) {
        if (outputIndex >= 0 && outputIndex < this.output.size()) {
            this.output.remove(outputIndex);
        }
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public String getOption(int optionIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return null;
        }
        return ((Option)this.options.get((int)optionIndex)).name;
    }

    public void addOption(String optionName) {
        this.insertOption(this.options.size(), optionName);
    }

    public void insertOption(int optionIndex, String optionName) {
        if (optionName != null && optionIndex >= 0 && optionIndex <= this.options.size()) {
            this.options.add(optionIndex, new Option(optionName));
        }
    }

    public void setOption(int optionIndex, String optionName) {
        if (optionName != null && optionIndex >= 0 && optionIndex < this.options.size()) {
            this.options.set(optionIndex, new Option(optionName));
        }
    }

    public void removeOption(int optionIndex) {
        if (optionIndex >= 0 && optionIndex < this.options.size()) {
            this.options.remove(optionIndex);
        }
    }

    public int getOptionOutputCount(int optionIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return 0;
        }
        return ((Option)this.options.get((int)optionIndex)).output.size();
    }

    public int getOptionOutputType(int optionIndex, int optionOutputIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return 0;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (optionOutputIndex < 0 || optionOutputIndex >= option.output.size()) {
            return 0;
        }
        if ("org.eclipse.vtp.output.File".equals(option.output.get(optionOutputIndex).getType())) {
            return 1;
        }
        if ("org.eclipse.vtp.output.Text".equals(option.output.get(optionOutputIndex).getType())) {
            return 2;
        }
        return 0;
    }

    public String getOptionOutputValue(int optionIndex, int optionOutputIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return null;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (optionOutputIndex < 0 || optionOutputIndex >= option.output.size()) {
            return null;
        }
        return option.output.get(optionOutputIndex).getProperty("value");
    }

    public void addOptionOutput(int optionIndex, Output o) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        option.output.add(o);
    }

    public void insertOptionOutput(int optionIndex, int optionOutputIndex, Output o) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (optionOutputIndex >= 0 && optionOutputIndex <= option.output.size()) {
            option.output.add(optionOutputIndex, o);
        }
    }

    public void setOptionOutput(int optionIndex, int optionOutputIndex, Output o) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (optionOutputIndex >= 0 && optionOutputIndex < option.output.size()) {
            option.output.set(optionOutputIndex, o);
        }
    }

    public void removeOptionOutput(int optionIndex, int optionOutputIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (optionOutputIndex >= 0 && optionOutputIndex < option.output.size()) {
            option.output.remove(optionOutputIndex);
        }
    }

    public String getOptionProperty(int optionIndex, String key) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return null;
        }
        return (String)((Option)this.options.get((int)optionIndex)).properties.get(key);
    }

    public void setOptionProperty(int optionIndex, String key, String value) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        if (value == null) {
            ((Option)this.options.get((int)optionIndex)).properties.remove(key);
        } else {
            ((Option)this.options.get((int)optionIndex)).properties.put(key, value);
        }
    }

    public int getOptionInputType(int optionIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return 0;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (option.input == null) {
            return 0;
        }
        return option.input.getType();
    }

    public String getOptionInputValue(int optionIndex) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return null;
        }
        Option option = (Option)this.options.get(optionIndex);
        if (option.input == null) {
            return null;
        }
        return option.input.getProperty("value");
    }

    public void setOptionInput(int optionIndex, Input i) {
        if (optionIndex < 0 || optionIndex >= this.options.size()) {
            return;
        }
        ((Option)this.options.get((int)optionIndex)).input = i;
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        List list = (List)this.parameters.get(name);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public void setParameterValues(String name, String[] values) {
        if (name == null) {
            return;
        }
        if (values == null) {
            this.parameters.remove(name);
        } else {
            LinkedList<String> list = (LinkedList<String>)this.parameters.get(name);
            if (list == null) {
                list = new LinkedList<String>();
                this.parameters.put(name, list);
            } else {
                list.clear();
            }
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    list.add(values[i]);
                }
                ++i;
            }
        }
    }

    @Override
    Object accept(IConversationCommandVisitor visitor) {
        return visitor.visitSelectionRequest(this);
    }

    public Object exportContents() {
        ArrayList<String> properties = new ArrayList<String>(this.properties.size() * 2);
        for (Map.Entry entry : this.properties.entrySet()) {
            properties.add((String)entry.getKey());
            properties.add((String)entry.getValue());
        }
        ArrayList<Object> output = new ArrayList<Object>(this.output.size() * 2);
        for (Output o : this.output) {
            output.add(o.getType());
            Set<String> propNames = o.getPropertyNames();
            String[] props = new String[propNames.size() * 2];
            int i = 0;
            Iterator<String> iterator = propNames.iterator();
            while (iterator.hasNext()) {
                String pn;
                props[i] = pn = iterator.next();
                props[i + 1] = o.getProperty(pn);
                ++i;
            }
            output.add(props);
        }
        ArrayList<Object> options = new ArrayList<Object>(this.options.size());
        for (Option entry : this.options) {
            options.add(entry.exportContents());
        }
        ArrayList<String> parameters = new ArrayList<String>(this.parameters.size() * 2);
        for (Map.Entry entry : this.parameters.entrySet()) {
            parameters.add((String)entry.getKey());
            parameters.add((String)entry.getValue());
        }
        return new Object[]{this.selectionName, this.resultName, this.filledResultValue, this.noInputResultValue, this.noMatchResultValue, properties.toArray(new String[properties.size()]), output.toArray(new Object[output.size()]), options.toArray(), parameters.toArray(new String[parameters.size()])};
    }

    public void importContents(Object contents) {
        Object[] array = (Object[])contents;
        this.selectionName = (String)array[0];
        this.resultName = (String)array[1];
        this.filledResultValue = (String)array[2];
        this.noInputResultValue = (String)array[3];
        this.noMatchResultValue = (String)array[4];
        this.properties.clear();
        String[] properties = (String[])array[5];
        int i = 0;
        while (i < properties.length) {
            this.properties.put(properties[i], properties[i + 1]);
            i += 2;
        }
        this.output.clear();
        Object[] output = (Object[])array[1];
        int i2 = 0;
        while (i2 < output.length) {
            Output o = new Output((String)output[i2]);
            String[] props = (String[])output[i2 + 1];
            int p = 0;
            while (p < props.length) {
                o.setProperty(props[p], props[p + 1]);
                p += 2;
            }
            this.output.add(o);
            i2 += 2;
        }
        this.parameters.clear();
        Object[] options = (Object[])array[7];
        int i3 = 0;
        while (i3 < options.length) {
            Option option = new Option();
            option.importContents(options[i3]);
            this.options.add(option);
            ++i3;
        }
        String[] parameters = (String[])array[8];
        int i4 = 0;
        while (i4 < parameters.length) {
            this.parameters.put(parameters[i4], parameters[i4 + 1]);
            i4 += 2;
        }
    }

    private static final class Option {
        String name;
        final List<Output> output = new ArrayList<Output>();
        final Map properties = new HashMap();
        Input input = null;

        Option() {
            this.name = null;
        }

        Option(String name) {
            this.name = name;
        }

        Object exportContents() {
            String pn;
            Iterator<String> iterator;
            int i;
            String[] props;
            Set<String> propNames;
            ArrayList<Object> output = new ArrayList<Object>(this.output.size() * 2);
            for (Output o : this.output) {
                output.add(o.getType());
                propNames = o.getPropertyNames();
                props = new String[propNames.size() * 2];
                i = 0;
                iterator = propNames.iterator();
                while (iterator.hasNext()) {
                    props[i] = pn = iterator.next();
                    props[i + 1] = o.getProperty(pn);
                    ++i;
                }
                output.add(props);
            }
            ArrayList<String> properties = new ArrayList<String>(this.properties.size() * 2);
            for (Map.Entry entry : this.properties.entrySet()) {
                properties.add((String)entry.getKey());
                properties.add((String)entry.getValue());
            }
            Object[] inputRef = new Object[2];
            if (this.input != null) {
                inputRef[0] = this.input.getType();
                propNames = this.input.getPropertyNames();
                props = new String[propNames.size() * 2];
                i = 0;
                iterator = propNames.iterator();
                while (iterator.hasNext()) {
                    props[i] = pn = iterator.next();
                    props[i + 1] = this.input.getProperty(pn);
                    ++i;
                }
                inputRef[1] = props;
            }
            return new Object[]{this.name, output.toArray(new Object[output.size()]), properties.toArray(new String[properties.size()]), inputRef};
        }

        void importContents(Object contents) {
            int p;
            String[] props;
            Object[] array = (Object[])contents;
            this.name = (String)array[0];
            this.output.clear();
            Object[] output = (Object[])array[1];
            int i = 0;
            while (i < output.length) {
                Output o = new Output((String)output[i]);
                props = (String[])output[i + 1];
                p = 0;
                while (p < props.length) {
                    o.setProperty(props[p], props[p + 1]);
                    p += 2;
                }
                this.output.add(o);
                i += 2;
            }
            String[] properties = (String[])array[2];
            int i2 = 0;
            while (i2 < properties.length) {
                this.properties.put(properties[i2], properties[i2 + 1]);
                i2 += 2;
            }
            Object[] inputRef = (Object[])array[3];
            if (inputRef[0] != null) {
                this.input = new Input((Integer)inputRef[0]);
                props = (String[])output[1];
                p = 0;
                while (p < props.length) {
                    this.input.setProperty(props[p], props[p + 1]);
                    p += 2;
                }
            }
        }
    }
}

