/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.MediaConfiguration;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BridgeMessageConfiguration
implements IConfiguration,
InteractionsConstants {
    private MediaConfiguration mediaConfiguration = null;
    private final IContentFactory contentFactory;

    public BridgeMessageConfiguration(IContentFactory contentFactory) {
        this.contentFactory = contentFactory;
    }

    public MediaConfiguration getMediaConfiguration() {
        return this.mediaConfiguration;
    }

    public void setMediaConfiguration(MediaConfiguration mediaConfiguration) {
        this.mediaConfiguration = mediaConfiguration;
    }

    public void load(Element configurationElement) {
        NodeList elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "media");
        this.mediaConfiguration = null;
        if (elements.getLength() == 0) {
            this.mediaConfiguration = null;
        } else {
            this.mediaConfiguration = new MediaConfiguration(this.contentFactory, null);
            this.mediaConfiguration.load((Element)elements.item(0));
        }
    }

    public void save(Element configurationElement) {
        if (this.mediaConfiguration == null) {
            return;
        }
        String mediaName = "media";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            mediaName = String.valueOf(prefix) + ":" + mediaName;
        }
        Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", mediaName);
        this.mediaConfiguration.save(element);
        configurationElement.appendChild(element);
    }
}

