/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExternalReferenceConfiguration
implements IConfiguration,
InteractionsConstants {
    private String name = "";
    private String url = "";
    private final Map inputs = new HashMap();
    private final Map outputs = new HashMap();
    private final Map urlParameters = new HashMap();

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public void setUrl(String url) {
        this.url = url == null ? "" : url;
    }

    public String[] getInputNames() {
        return this.inputs.keySet().toArray(new String[this.inputs.size()]);
    }

    public boolean isInputVariable(String name) {
        Input input = (Input)this.inputs.get(name);
        return input != null && input.variable;
    }

    public String getInputValue(String name) {
        Input input = (Input)this.inputs.get(name);
        return input == null ? null : input.value;
    }

    public void setInput(String name, boolean variable, String value) {
        this.inputs.put(name, new Input(variable, value));
    }

    public void removeInput(String name) {
        this.inputs.remove(name);
    }

    public String[] getURLParameterNames() {
        return this.urlParameters.keySet().toArray(new String[this.urlParameters.size()]);
    }

    public boolean isURLParameterVariable(String name) {
        URLParameter input = (URLParameter)this.urlParameters.get(name);
        return input != null && input.variable;
    }

    public String getURLParameterValue(String name) {
        URLParameter input = (URLParameter)this.urlParameters.get(name);
        return input == null ? null : input.value;
    }

    public void setURLParameter(String name, boolean variable, String value) {
        this.urlParameters.put(name, new URLParameter(variable, value));
    }

    public void removeURLParameter(String name) {
        this.urlParameters.remove(name);
    }

    public String[] getOutputNames() {
        return this.outputs.keySet().toArray(new String[this.outputs.size()]);
    }

    public String getOutputValue(String name) {
        return (String)this.outputs.get(name);
    }

    public void setOutput(String name, String value) {
        this.outputs.put(name, value);
    }

    public void removeOutput(String name) {
        this.outputs.remove(name);
    }

    public void load(Element configurationElement) {
        String value;
        String type;
        String key;
        Element itemElement;
        this.name = configurationElement.getAttribute("name");
        this.url = configurationElement.getAttribute("value");
        this.inputs.clear();
        NodeList itemElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "input-item");
        int i = 0;
        while (i < itemElements.getLength()) {
            itemElement = (Element)itemElements.item(i);
            key = itemElement.getAttribute("key");
            type = itemElement.getAttribute("type");
            value = itemElement.getAttribute("value");
            this.inputs.put(key, new Input("variable".equals(type), value));
            ++i;
        }
        this.urlParameters.clear();
        itemElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "url-parameter-item");
        i = 0;
        while (i < itemElements.getLength()) {
            itemElement = (Element)itemElements.item(i);
            key = itemElement.getAttribute("key");
            type = itemElement.getAttribute("type");
            value = itemElement.getAttribute("value");
            this.urlParameters.put(key, new URLParameter("variable".equals(type), value));
            ++i;
        }
        this.outputs.clear();
        itemElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "output-item");
        i = 0;
        while (i < itemElements.getLength()) {
            itemElement = (Element)itemElements.item(i);
            key = itemElement.getAttribute("key");
            String value2 = itemElement.getAttribute("value");
            this.outputs.put(key, value2);
            ++i;
        }
    }

    public void save(Element configurationElement) {
        Object input;
        Element element;
        configurationElement.setAttribute("name", this.name);
        configurationElement.setAttribute("value", this.url);
        String inputItemName = "input-item";
        String outputItemName = "output-item";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            inputItemName = String.valueOf(prefix) + ":" + inputItemName;
            outputItemName = String.valueOf(prefix) + ":" + outputItemName;
        }
        for (Map.Entry entry : this.inputs.entrySet()) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", inputItemName);
            element.setAttribute("key", (String)entry.getKey());
            input = (Input)entry.getValue();
            element.setAttribute("type", ((Input)input).variable ? "variable" : "static");
            element.setAttribute("value", ((Input)input).value);
            configurationElement.appendChild(element);
        }
        for (Map.Entry entry : this.urlParameters.entrySet()) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "url-parameter-item");
            element.setAttribute("key", (String)entry.getKey());
            input = (URLParameter)entry.getValue();
            element.setAttribute("type", ((URLParameter)input).variable ? "variable" : "static");
            element.setAttribute("value", ((URLParameter)input).value);
            configurationElement.appendChild(element);
        }
        for (Map.Entry entry : this.outputs.entrySet()) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", outputItemName);
            element.setAttribute("key", (String)entry.getKey());
            element.setAttribute("value", (String)entry.getValue());
            configurationElement.appendChild(element);
        }
    }

    private static final class Input {
        final boolean variable;
        final String value;

        Input(boolean variable, String value) {
            this.variable = variable;
            this.value = value;
        }
    }

    private static final class URLParameter {
        final boolean variable;
        final String value;

        URLParameter(boolean variable, String value) {
            this.variable = variable;
            this.value = value;
        }
    }
}

