/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputNode;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;

public class OutputCase
implements InteractionsConstants {
    private String script = "";
    private String scriptingLanguage = "";
    private OutputNode[] nodes = null;

    public OutputCase() {
    }

    public OutputCase(String script, String scriptingLanguage, OutputNode[] nodes) {
        this.script = script;
        this.scriptingLanguage = scriptingLanguage;
        this.nodes = nodes;
    }

    public String getScriptingLanguage() {
        return this.scriptingLanguage;
    }

    public void setScriptingLanguage(String scriptingLanguage) {
        this.scriptingLanguage = scriptingLanguage;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public OutputNode[] getNodes() {
        return this.nodes;
    }

    public void setNodes(OutputNode[] nodes) {
        this.nodes = nodes;
    }

    void load(Element configurationElement, IContentFactory contentFactory) {
        this.script = configurationElement.getAttribute("script");
        this.scriptingLanguage = configurationElement.getAttribute("scripting-language");
        this.nodes = OutputNode.loadAll(configurationElement, contentFactory);
    }

    void save(Element configurationElement) {
        String outputNodeName = "output-node-case";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            outputNodeName = String.valueOf(prefix) + ":" + outputNodeName;
        }
        Element outputNodeElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", outputNodeName);
        if (this.nodes != null) {
            int j = 0;
            while (j < this.nodes.length) {
                this.nodes[j].save(outputNodeElement);
                ++j;
            }
        }
        outputNodeElement.setAttribute("script", this.script);
        outputNodeElement.setAttribute("scripting-language", this.scriptingLanguage);
        configurationElement.appendChild(outputNodeElement);
    }
}

