/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.ArrayList;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputCase;
import org.eclipse.vtp.framework.interactions.core.configurations.OutputNode;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutputSwitch
extends OutputNode
implements InteractionsConstants {
    private OutputCase[] cases = null;

    public OutputSwitch() {
    }

    public OutputSwitch(OutputCase[] cases) {
        this.cases = cases;
    }

    public OutputCase[] getCases() {
        return this.cases;
    }

    public void setCases(OutputCase[] cases) {
        this.cases = cases;
    }

    @Override
    void load(Element configurationElement, IContentFactory contentFactory) {
        NodeList childElements = configurationElement.getChildNodes();
        ArrayList<OutputCase> cases = new ArrayList<OutputCase>(childElements.getLength());
        int j = 0;
        while (j < childElements.getLength()) {
            if (childElements.item(j) instanceof Element) {
                OutputCase c = new OutputCase();
                c.load((Element)childElements.item(j), contentFactory);
                cases.add(c);
            }
            ++j;
        }
        this.cases = cases.toArray(new OutputCase[cases.size()]);
    }

    @Override
    void save(Element configurationElement) {
        String outputNodeName = "output-node-switch";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            outputNodeName = String.valueOf(prefix) + ":" + outputNodeName;
        }
        Element outputNodeElement = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", outputNodeName);
        if (this.cases != null) {
            int j = 0;
            while (j < this.cases.length) {
                this.cases[j].save(outputNodeElement);
                ++j;
            }
        }
        configurationElement.appendChild(outputNodeElement);
    }
}

