/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyConfiguration
implements IConfiguration,
InteractionsConstants {
    public static final String STATIC = "static";
    public static final String EXPRESSION = "expression";
    public static final String VARIABLE = "variable";
    private final Map<String, Value> items = new HashMap<String, Value>();

    public Value getItem(String brandName, String interactionTypeID) {
        return this.getItem(brandName, interactionTypeID, "");
    }

    public Value getItem(String brandName, String interactionTypeID, String language) {
        String key = String.valueOf(brandName) + interactionTypeID + language;
        return this.items.get(key);
    }

    public void setItem(String brandName, String interactionTypeID, String type, String value) {
        this.setItem(String.valueOf(brandName) + interactionTypeID, new Value(type, value));
    }

    public void setItem(String key, String type, String value) {
        this.setItem(key, new Value(type, value));
    }

    public void setItem(String key, Value value) {
        if (value == null) {
            this.items.remove(key);
        } else {
            this.items.put(key, value);
        }
    }

    public void setItem(String brandName, String interactionTypeID, String language, String type, String value) {
        this.setItem(String.valueOf(brandName) + interactionTypeID + language, new Value(type, value));
    }

    public void load(Element configurationElement) {
        this.items.clear();
        NodeList propertyItemElements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "property-item");
        int i = 0;
        while (i < propertyItemElements.getLength()) {
            Element propertyItemElement = (Element)propertyItemElements.item(i);
            String key = propertyItemElement.getAttribute("key");
            String type = propertyItemElement.getAttribute("type");
            if (type == null || "".equals(type)) {
                type = STATIC;
            }
            try {
                this.items.put(key, new Value(type, XMLUtilities.getElementTextData((Element)propertyItemElement, (boolean)true)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            ++i;
        }
    }

    public void save(Element configurationElement) {
        String propertyItemName = "property-item";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            propertyItemName = String.valueOf(prefix) + ":" + propertyItemName;
        }
        for (Map.Entry<String, Value> entry : this.items.entrySet()) {
            Element element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", propertyItemName);
            element.setAttribute("key", entry.getKey());
            element.setAttribute("type", entry.getValue().getType());
            element.appendChild(configurationElement.getOwnerDocument().createTextNode(entry.getValue().getValue()));
            configurationElement.appendChild(element);
        }
    }

    public class Value {
        String type = null;
        String value = null;

        public Value(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

