/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.configurations;

import org.eclipse.vtp.framework.core.IConfiguration;
import org.eclipse.vtp.framework.interactions.core.configurations.InteractionsConstants;
import org.eclipse.vtp.framework.interactions.core.configurations.PropertyConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransferMessageConfiguration
implements IConfiguration,
InteractionsConstants {
    private PropertyConfiguration type = null;
    private PropertyConfiguration destination = null;

    public PropertyConfiguration getType() {
        return this.type;
    }

    public void setType(PropertyConfiguration type) {
        this.type = type;
    }

    public PropertyConfiguration getDestination() {
        return this.destination;
    }

    public void setDestination(PropertyConfiguration destination) {
        this.destination = destination;
    }

    public void load(Element configurationElement) {
        this.destination = null;
        NodeList elements = configurationElement.getElementsByTagNameNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", "property");
        int i = 0;
        while (i < elements.getLength()) {
            Element e = (Element)elements.item(i);
            if ("type".equalsIgnoreCase(e.getAttribute("name"))) {
                this.type = new PropertyConfiguration();
                this.type.load(e);
            } else if ("destination".equalsIgnoreCase(e.getAttribute("name"))) {
                this.destination = new PropertyConfiguration();
                this.destination.load(e);
            }
            ++i;
        }
    }

    public void save(Element configurationElement) {
        Element element;
        String propertyName = "property";
        String prefix = configurationElement.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            propertyName = String.valueOf(prefix) + ":" + propertyName;
        }
        if (this.type != null) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", propertyName);
            this.type.save(element);
            element.setAttribute("name", "type");
            configurationElement.appendChild(element);
        }
        if (this.destination != null) {
            element = configurationElement.getOwnerDocument().createElementNS("http://eclipse.org/vtp/xml/framework/interactions/core/configurations", propertyName);
            this.destination.save(element);
            element.setAttribute("name", "destination");
            configurationElement.appendChild(element);
        }
    }
}

