/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IContentFactory;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ContentComposite
extends Content {
    public static final String ELEMENT_NAME = "composite-content";
    private List<Content> children = new ArrayList<Content>();

    public ContentComposite() {
    }

    public ContentComposite(List<Content> content) {
        this.children.addAll(content);
    }

    public ContentComposite(IContentFactory factory, Element element) {
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Content c;
            if (nl.item(i).getNodeType() == 1 && (c = factory.loadContent((Element)nl.item(i))) != null) {
                this.children.add(c);
            }
            ++i;
        }
    }

    public void addContent(Content content) {
        this.children.remove(content);
        this.children.add(content);
    }

    public void removeContent(Content content) {
        this.children.remove(content);
    }

    public void moveContentUp(Content content) {
        int idex = this.children.indexOf(content);
        if (idex < 1) {
            return;
        }
        this.children.remove(content);
        this.children.add(idex - 1, content);
    }

    public void moveContentDown(Content content) {
        int idex = this.children.indexOf(content);
        if (idex < 0 || idex > this.children.size() - 2) {
            return;
        }
        this.children.remove(content);
        this.children.add(idex + 1, content);
    }

    public List<Content> listContent() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/content", ELEMENT_NAME);
        element.appendChild(thisElement);
        for (Content c : this.children) {
            c.store(thisElement);
        }
        return thisElement;
    }

    @Override
    public String getContentType() {
        return "org.eclipse.vtp.framework.interactions.core.media.content.composite";
    }

    @Override
    public boolean isResolvable() {
        return true;
    }

    @Override
    public List<Content> resolve(IMediaProvider mediaProvider) {
        LinkedList<Content> ret = new LinkedList<Content>();
        for (Content c : this.children) {
            if (c.isResolvable()) {
                ret.addAll(c.resolve(mediaProvider));
                continue;
            }
            ret.add(c);
        }
        return ret;
    }

    @Override
    public Content createCopy() {
        ContentComposite copy = new ContentComposite();
        for (Content c : this.children) {
            copy.addContent(c.createCopy());
        }
        return copy;
    }
}

