/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class FileContent
extends Content {
    public static final int STATIC_PATH = 1;
    public static final int VARIABLE_PATH = 2;
    private int dataType = 1;
    private String data = "";

    public FileContent() {
    }

    public FileContent(Element element) {
        String dataTypeString = element.getAttribute("dataType");
        this.dataType = dataTypeString.equals("") ? 1 : ("static".equalsIgnoreCase(dataTypeString) ? 1 : ("variable".equalsIgnoreCase(dataTypeString) ? 2 : Integer.parseInt(dataTypeString)));
        this.data = XMLUtilities.getElementTextDataNoEx((Element)element, (boolean)true);
        if (this.data == null) {
            this.data = "";
        }
    }

    public void setStaticPath(String path) {
        this.dataType = 1;
        this.data = path;
    }

    public void setVariablePath(String variable) {
        this.dataType = 2;
        this.data = variable;
    }

    public String getPath() {
        return this.data;
    }

    public int getPathType() {
        return this.dataType;
    }

    public String getFileTypeName() {
        return "FILE";
    }

    @Override
    public boolean isDataAware() {
        return this.dataType == 2;
    }

    @Override
    public Content captureData(IDataSet dataSet) {
        if (this.dataType == 1) {
            return this;
        }
        FileContent clone = (FileContent)this.createCopy();
        clone.setStaticPath(dataSet.getData(this.data).toString());
        return clone;
    }

    protected void storeBaseInfo(Element thisElement) {
        thisElement.setAttribute("dataType", this.dataType == 1 ? "static" : "variable");
        Text dataNode = thisElement.getOwnerDocument().createTextNode(this.data);
        thisElement.appendChild(dataNode);
    }
}

