/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.media;

import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IDataSet;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PlaceholderContent
extends Content {
    public static final String ELEMENT_NAME = "placeholder-content";
    private String data = "";

    public PlaceholderContent() {
    }

    public PlaceholderContent(Element element) {
        this.data = XMLUtilities.getElementTextDataNoEx((Element)element, (boolean)true);
        if (this.data == null) {
            this.data = "";
        }
    }

    public void setPlaceholder(String name) {
        this.data = name;
    }

    public String getPlaceholder() {
        return this.data;
    }

    @Override
    public Element store(Element element) {
        Element thisElement = element.getOwnerDocument().createElementNS("http://www.eclipse.org/vtp/media/content", ELEMENT_NAME);
        element.appendChild(thisElement);
        Text dataNode = thisElement.getOwnerDocument().createTextNode(this.data);
        thisElement.appendChild(dataNode);
        return thisElement;
    }

    @Override
    public String getContentType() {
        return "org.eclipse.vtp.framework.interactions.core.media.content.placeholder";
    }

    @Override
    public boolean isDataAware() {
        return false;
    }

    @Override
    public Content captureData(IDataSet dataSet) {
        return this;
    }

    @Override
    public Content createCopy() {
        PlaceholderContent copy = new PlaceholderContent();
        copy.data = this.data;
        return copy;
    }
}

