/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class InputManager
implements IInputGrammarFactory {
    private final Map inputTypeIndex;

    public InputManager(IExtensionRegistry registry) {
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.vtp.framework.interactions.core.inputtypes");
        IExtension[] extensions = point.getExtensions();
        HashMap<String, InputType> inputTypeIndex = new HashMap<String, InputType>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            Bundle bundle = Platform.getBundle((String)extensions[i].getContributor().getName());
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    InputType inputType = new InputType(elements[j].getAttribute("id"), elements[j].getAttribute("class"), bundle.loadClass(elements[j].getAttribute("class")));
                    inputTypeIndex.put(String.valueOf(elements[j].getAttribute("element-name")) + elements[j].getAttribute("element-uri"), inputType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        this.inputTypeIndex = Collections.unmodifiableMap(inputTypeIndex);
    }

    @Override
    public InputGrammar loadInput(Element configuration) {
        if (configuration == null) {
            return null;
        }
        InputType inputType = (InputType)this.inputTypeIndex.get(String.valueOf(configuration.getLocalName()) + configuration.getNamespaceURI());
        if (inputType == null) {
            return null;
        }
        return inputType.newInstance(configuration);
    }

    private final class InputType {
        private final String id;
        private final String name;
        private final Constructor constructor;

        InputType(String id, String name, Class contentClass) {
            this.id = id;
            Constructor constructor = null;
            this.name = name;
            try {
                constructor = contentClass.getConstructor(IInputGrammarFactory.class, Element.class);
            }
            catch (NoSuchMethodException e) {
                try {
                    constructor = contentClass.getConstructor(Element.class);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            this.constructor = constructor;
        }

        InputGrammar newInstance(Element configuration) {
            try {
                if (this.constructor.getParameterTypes().length == 1) {
                    return (InputGrammar)this.constructor.newInstance(configuration);
                }
                return (InputGrammar)this.constructor.newInstance(InputManager.this, configuration);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

