/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.vtp.framework.interactions.core.IInteractionType;
import org.eclipse.vtp.framework.interactions.core.IInteractionTypeRegistry;

public class InteractionTypeRegistry
implements IInteractionTypeRegistry {
    private final Map interactionTypes;

    public InteractionTypeRegistry(IExtensionRegistry registry) {
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.vtp.framework.interactions.core.interactionTypes");
        IExtension[] extensions = point.getExtensions();
        HashMap<String, InteractionType> interactionTypes = new HashMap<String, InteractionType>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                InteractionType contentType = new InteractionType(elements[j].getAttribute("id"), elements[j].getAttribute("name"));
                interactionTypes.put(contentType.getId(), contentType);
                ++j;
            }
            ++i;
        }
        this.interactionTypes = Collections.unmodifiableMap(interactionTypes);
    }

    @Override
    public String[] getInteractionTypeIDs() {
        return this.interactionTypes.keySet().toArray(new String[this.interactionTypes.size()]);
    }

    @Override
    public IInteractionType getInteractionType(String interactionTypeID) {
        return (IInteractionType)this.interactionTypes.get(interactionTypeID);
    }

    private final class InteractionType
    implements IInteractionType {
        private final String id;
        private final String name;

        InteractionType(String id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

