/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import java.util.Locale;
import org.eclipse.vtp.framework.common.IBrandSelection;
import org.eclipse.vtp.framework.common.IScriptable;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.core.ISessionContext;
import org.eclipse.vtp.framework.interactions.core.ILanguage;
import org.eclipse.vtp.framework.interactions.core.ILanguageRegistry;
import org.eclipse.vtp.framework.interactions.core.ILanguageSelection;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProviderRegistry;

public class LanguageSelection
implements ILanguageSelection,
IScriptable {
    private final ISessionContext context;
    private final ILanguageRegistry languageRegistry;

    public LanguageSelection(ISessionContext context, ILanguageRegistry languageRegistry, IBrandSelection brandSelection, IMediaProviderRegistry mediaProviderRegistry) {
        String[] ids;
        this.context = context;
        this.languageRegistry = languageRegistry;
        String defaultLanguage = null;
        if (context.isDebugEnabled()) {
            context.debug("Selected Brand: " + brandSelection.getSelectedBrand().getId());
        }
        String[] stringArray = ids = languageRegistry.getLanguageIDs("org.eclipse.vtp.framework.interactions.voice.interaction");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (context.isDebugEnabled()) {
                context.debug("Language: " + id);
            }
            String providerId = mediaProviderRegistry.lookupMediaProviderID(brandSelection.getSelectedBrand().getId(), "org.eclipse.vtp.framework.interactions.voice.interaction", id);
            if (context.isDebugEnabled()) {
                context.debug("Media Provider Id: " + providerId);
                context.debug(mediaProviderRegistry.getMediaProvider(providerId).getFormatter().toString());
            }
            ++n2;
        }
        Locale locale = Locale.getDefault();
        int i = 0;
        while (defaultLanguage == null && i < ids.length) {
            if (locale.equals(mediaProviderRegistry.getMediaProvider(mediaProviderRegistry.lookupMediaProviderID(brandSelection.getSelectedBrand().getId(), "org.eclipse.vtp.framework.interactions.voice.interaction", ids[i])).getFormatter().getLanguageCode())) {
                defaultLanguage = ids[i];
            }
            ++i;
        }
        if (defaultLanguage == null) {
            locale = new Locale(locale.getLanguage(), locale.getCountry());
            i = 0;
            while (defaultLanguage == null && i < ids.length) {
                if (locale.equals(mediaProviderRegistry.getMediaProvider(mediaProviderRegistry.lookupMediaProviderID(brandSelection.getSelectedBrand().getId(), "org.eclipse.vtp.framework.interactions.voice.interaction", ids[i])).getFormatter().getLanguageCode())) {
                    defaultLanguage = ids[i];
                }
                ++i;
            }
            if (defaultLanguage == null) {
                locale = new Locale(locale.getLanguage());
                i = 0;
                while (defaultLanguage == null && i < ids.length) {
                    if (locale.equals(mediaProviderRegistry.getMediaProvider(mediaProviderRegistry.lookupMediaProviderID(brandSelection.getSelectedBrand().getId(), "org.eclipse.vtp.framework.interactions.voice.interaction", ids[i])).getFormatter().getLanguageCode())) {
                        defaultLanguage = ids[i];
                    }
                    ++i;
                }
            }
        }
        if (defaultLanguage == null && ids.length > 0) {
            defaultLanguage = ids[0];
        }
        context.setAttribute("language.default.locale", defaultLanguage);
    }

    @Override
    public String getSelectedLanguage() {
        String id = (String)this.context.getAttribute("language.selection");
        if ((id == null || id.equals("")) && ((id = (String)this.context.getAttribute("language.default.user")) == null || id.equals(""))) {
            id = (String)this.context.getAttribute("language.default.locale");
        }
        return id;
    }

    @Override
    public void setDefaultLanguage(String languageId) {
        String[] ids;
        if (languageId == null) {
            this.context.clearAttribute("language.default.user");
            return;
        }
        String[] stringArray = ids = this.languageRegistry.getLanguageIDs("org.eclipse.vtp.framework.interactions.voice.interaction");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(languageId)) {
                this.context.setAttribute("language.default.user", (Object)languageId);
                break;
            }
            ++n2;
        }
    }

    @Override
    public boolean setSelectedLanguage(String languageId) {
        String[] ids;
        if (languageId == null) {
            this.context.clearAttribute("language.selection");
            return true;
        }
        String[] stringArray = ids = this.languageRegistry.getLanguageIDs("org.eclipse.vtp.framework.interactions.voice.interaction");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(languageId)) {
                this.context.setAttribute("language.selection", (Object)languageId);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean clearEntry(String name) {
        if ("value".equals(name)) {
            this.setSelectedLanguage(null);
            return true;
        }
        return false;
    }

    public boolean clearItem(int index) {
        return false;
    }

    public Object getEntry(String name) {
        if ("value".equals(name)) {
            return this.getSelectedLanguage();
        }
        return null;
    }

    public String[] getFunctionNames() {
        return new String[0];
    }

    public Object getItem(int index) {
        return null;
    }

    public String getName() {
        return "SelectedLanguage";
    }

    public String[] getPropertyNames() {
        return new String[]{"value"};
    }

    public boolean hasEntry(String name) {
        return "value".equals(name);
    }

    public boolean hasItem(int index) {
        return false;
    }

    public boolean hasValue() {
        return true;
    }

    public Object invokeFunction(String name, Object[] arguments) {
        return null;
    }

    public boolean setEntry(String name, Object value) {
        if ("value".equals(name)) {
            String val = "";
            if (value instanceof ILanguage) {
                val = ((ILanguage)value).getID();
            } else if (value instanceof String) {
                val = (String)value;
            } else if (value instanceof IStringObject) {
                val = ((IStringObject)value).getValue();
            }
            return this.setSelectedLanguage(val);
        }
        return false;
    }

    public boolean setItem(int index, Object value) {
        return false;
    }

    public Object toValue() {
        return this.getSelectedLanguage();
    }

    public boolean isMutable() {
        return false;
    }
}

