/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.services;

import org.eclipse.vtp.framework.core.IExecutionContext;
import org.eclipse.vtp.framework.interactions.core.platforms.IPlatform;
import org.eclipse.vtp.framework.interactions.core.platforms.IPlatformSelector;

public class PlatformSelector
implements IPlatformSelector {
    private static final String[] PARAMETERS = new String[]{"USER_AGENT", "ACCEPT", "MODE"};
    private static final String[] PREFIXES;
    private final IExecutionContext context;
    private IPlatform selectedPlatform = null;

    static {
        String[] prefixes = new String[PARAMETERS.length];
        StringBuffer buffer = new StringBuffer(IPlatform.class.getName()).append(':');
        int resetLength = buffer.length();
        int i = 0;
        while (i < prefixes.length) {
            if (i > 0) {
                buffer.setLength(resetLength);
            }
            prefixes[i] = buffer.append(PARAMETERS[i]).append('=').toString();
            ++i;
        }
        PREFIXES = prefixes;
    }

    public PlatformSelector(IExecutionContext context) {
        this.context = context;
        this.selectedPlatform = this.selectPlatform();
    }

    public IPlatform selectPlatform() {
        int i = 0;
        while (i < PARAMETERS.length) {
            String[] values = this.context.getParameters(PARAMETERS[i]);
            if (values != null) {
                int j = 0;
                while (j < values.length) {
                    Object platform;
                    if (values[j] != null && (platform = this.context.lookup(String.valueOf(PREFIXES[i]) + values[j])) instanceof IPlatform) {
                        return (IPlatform)platform;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object platform = this.context.lookup(IPlatform.class.getName());
        if (platform instanceof IPlatform) {
            return (IPlatform)platform;
        }
        return null;
    }

    @Override
    public IPlatform getSelectedPlatform() {
        return this.selectedPlatform;
    }
}

