/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.support;

import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;

public class RawDocument
implements IDocument {
    private final String documentType;
    private final String contentType;
    private final StringBuffer text = new StringBuffer();
    private boolean secured = false;
    private boolean cachable = true;

    public RawDocument(String documentType) {
        this(documentType, null);
    }

    public RawDocument(String documentType, String contentType) {
        this.documentType = documentType;
        this.contentType = contentType == null ? "text/xml" : contentType;
    }

    public void appendText(String text) {
        this.text.append(text);
    }

    public void clearText() {
        this.text.setLength(0);
    }

    @Override
    public String getDocumentType() {
        return this.documentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Source toXMLSource() throws IllegalStateException {
        return new StreamSource(new StringReader(this.text.toString()));
    }

    public String toString() {
        return this.text.toString();
    }

    @Override
    public boolean isSecured() {
        return this.secured;
    }

    @Override
    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    @Override
    public boolean isCachable() {
        return this.cachable;
    }

    public void setCachable(boolean bool) {
        this.cachable = bool;
    }
}

