/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.eclipse.vtp.framework.interactions.core.platforms.IDocument;
import org.eclipse.vtp.framework.interactions.core.support.Widget;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class WidgetDocument
extends Widget
implements IDocument {
    private boolean secured = false;
    private boolean cachable = true;

    protected WidgetDocument() {
    }

    @Override
    public boolean isCachable() {
        return this.cachable;
    }

    public void setCachable(boolean bool) {
        this.cachable = bool;
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public Source toXMLSource() throws IllegalStateException {
        return new SAXSource(new WidgetReader(), new InputSource());
    }

    @Override
    public boolean isSecured() {
        return this.secured;
    }

    @Override
    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    private final class WidgetReader
    implements XMLReader {
        private final Map features = new HashMap();
        private final Map properties = new HashMap();
        private ContentHandler contentHandler = null;
        private DTDHandler dtdHandler = null;
        private EntityResolver entityResolver = null;
        private ErrorHandler errorHandler = null;

        private WidgetReader() {
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return Boolean.TRUE.equals(this.features.get(name));
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.properties.get(name);
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        @Override
        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        @Override
        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (value) {
                this.features.put(name, Boolean.TRUE);
            } else {
                this.features.remove(name);
            }
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            if (value == null) {
                this.properties.remove(name);
            } else {
                this.properties.put(name, value);
            }
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.contentHandler = handler;
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
            this.dtdHandler = handler;
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
            this.entityResolver = resolver;
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            WidgetDocument.this.writeWidget(this.contentHandler);
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            WidgetDocument.this.writeWidget(this.contentHandler);
        }
    }
}

